/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.introspection;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.stp.core.sca.impl.EObjectContainmentIntrospectingEList;

/**
 * 
 * Provides a safe wrapper for introspectors to run. ISafeIntrospectors are used
 * under the covers when the ComponentType lists are introspected.
 * 
 * @since 1.0
 * 
 */
public interface ISafeIntrospector extends ISafeRunnable {

   /**
    * Set the current list. Depending on the implementaiton, the list could
    * contain Properties, References, or Services.
    * 
    * Specific implementations of this interface will know what to expect as
    * implementations are only anonymous inner classes.
    * 
    * @param aList
    *           A list of either Properties, References, or Services (or empty).
    */
   void setTargetList(EObjectContainmentIntrospectingEList aList);

}
