/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.builders;

import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.builders.JavaDocumentUtils;
import org.eclipse.stp.sc.jaxws.generators.types.JaxBindTypeGenerator;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IJavaToWsdlGenerator;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;

public abstract class ScJavaBuilder
extends IncrementalProjectBuilder {
    private static final String WSDL_OUTPUT_DIR = "wsdl";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ScJavaBuilder.class);

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        LOG.debug((Object)("fullBuild for project:" + this.getProject().getName()));
        this.getProject().accept((IResourceVisitor)new ScBuildVisitor());
        this.getProject().refreshLocal(2, monitor);
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        LOG.debug((Object)("incrementalBuild for project:" + this.getProject().getName()));
        delta.accept((IResourceDeltaVisitor)new ScBuildDeltaVisitor());
        this.getProject().refreshLocal(2, monitor);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        LOG.debug((Object)("clean for the project:" + this.getProject().getName()));
        IProject proj = this.getProject();
        IFolder wsdlFolder = proj.getFolder(WSDL_OUTPUT_DIR);
        wsdlFolder.delete(true, monitor);
        this.getProject().refreshLocal(2, null);
    }

    protected void buildOneJavaFile(IFile javaFile) throws CoreException {
        try {
            ICompilationUnit compUnit = JDTUtils.getJavaUnitFromFile((IFile)javaFile);
            if (JavaDocumentUtils.needToGenerateWrapper(compUnit)) {
                LOG.info((Object)("generate wrapper type classes for SEI:" + compUnit.findPrimaryType().getFullyQualifiedName()));
                JaxBindTypeGenerator typeGen = new JaxBindTypeGenerator();
                typeGen.createWrapperCls(compUnit);
            }
            this.generate(javaFile.getFullPath(), this.getProject(), null);
        }
        catch (Exception e) {
            LOG.debug((Object)"generation failure", (Throwable)e);
            Status status = new Status(4, "org.eclipse.core.resources", 75, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    protected void startupOnInitialize() {
    }

    private void visitResourceFile(IResource res) throws CoreException {
        if (!(res instanceof IFile)) {
            return;
        }
        IFile file = (IFile)res;
        if (!file.getFileExtension().equals("java")) {
            return;
        }
        if (JavaDocumentUtils.hasWebServiceAnnotation(file)) {
            this.buildOneJavaFile(file);
        }
    }

    private void removeResourceFile(IResource res) throws CoreException {
        if (!(res instanceof IFile)) {
            return;
        }
        IFile file = (IFile)res;
        if (!file.getFileExtension().equals("java")) {
            return;
        }
        if (JavaDocumentUtils.hasWebServiceAnnotation(file)) {
            LOG.debug((Object)("WebService java file has been removed:" + file.getFullPath()));
            String clsName = JDTUtils.getJavaClassNameFromFile((IFile)file);
            if (clsName.lastIndexOf(".") > 0) {
                clsName = clsName.substring(clsName.lastIndexOf("."));
            }
            String wsdlName = String.valueOf(clsName) + ".wsdl";
            LOG.debug((Object)("  need to remove:" + wsdlName));
            IContainer folder = JaxWsWorkspaceManager.getWSDLFolder(this.getProject());
            IResource wsdlResource = folder.findMember(wsdlName);
            if (wsdlResource.exists()) {
                LOG.debug((Object)("delete wsdl resource:" + wsdlResource.getFullPath()));
                wsdlResource.delete(1, null);
            }
        }
    }

    public void generate(IPath path, IProject project, Object data) throws CoreException {
        IJavaToWsdlGenerator generator = ScJaxWsPlugin.getRuntimeProviderManager().getJavaToWsdlGenerator(project);
        if (data != null) {
            generator.setInitializationData(null, null, data);
        }
        generator.run(path, project);
    }

    class ScBuildDeltaVisitor
    implements IResourceDeltaVisitor {
        ScBuildDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            switch (delta.getKind()) {
                case 1: 
                case 4: {
                    ScJavaBuilder.this.visitResourceFile(res);
                    break;
                }
                case 2: {
                    LOG.debug((Object)("DeltaVistor, removed resource:" + res.getFullPath()));
                    try {
                        ScJavaBuilder.this.removeResourceFile(res);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"builder error", (Throwable)e);
                    }
                    break;
                }
            }
            return true;
        }
    }

    class ScBuildVisitor
    implements IResourceVisitor {
        ScBuildVisitor() {
        }

        public boolean visit(IResource res) throws CoreException {
            ScJavaBuilder.this.visitResourceFile(res);
            return true;
        }
    }
}

