/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.wsdltojava;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.wizards.AbstractScWizard;
import org.eclipse.stp.sc.common.wizards.AbstractScWizardPage;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IParameterPage;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.utils.ScJDTUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralInfoPage
extends AbstractScWizardPage {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(GeneralInfoPage.class);
    protected IProject project;
    protected Combo cboOutputDir;
    protected Hashtable<String, IPath> possibleNewPaths = new Hashtable();
    protected IParameterPage paramPage;
    private static ImageDescriptor defaultImgDesc = ScJaxWsResources.getImageDescriptor("wizban/wsdl_to_java_wiz.gif");

    public GeneralInfoPage(AbstractScWizard aParentWizard, String pageName, String aHelpContextId) {
        super(aParentWizard, pageName, aHelpContextId);
        this.setTitle(ScJaxWsResources.getString("WsdlToJava.GeneralInfoPage.Title"));
        this.setDescription(ScJaxWsResources.getString("WsdlToJava.GeneralInfoPage.Description"));
        this.setImageDescriptor(defaultImgDesc);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Group grpParams = new Group(container, 0);
        grpParams.setLayoutData((Object)new GridData(1808));
        grpParams.setLayout((Layout)new GridLayout(1, false));
        grpParams.setText(ScJaxWsResources.getString("Wsdl.To.Java.Gen.Param.Title"));
        this.project = (IProject)this.parentWizard.getWizardData().get("DATA_PROJECT");
        RuntimeProviderManager rtMgr = RuntimeProviderManager.getInstance();
        this.paramPage = rtMgr.getParameterPage(this.project);
        this.paramPage.createContents((Composite)grpParams);
        this.paramPage.setPage((WizardPage)this);
        Group grpOutputDir = new Group(container, 0);
        grpOutputDir.setText(ScJaxWsResources.getString("WsdlToJava.GeneralInfoPage.OutputDir.Label"));
        grpOutputDir.setLayoutData((Object)new GridData(768));
        grpOutputDir.setLayout((Layout)new GridLayout(1, false));
        this.cboOutputDir = new Combo((Composite)grpOutputDir, 12);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.cboOutputDir.setLayoutData((Object)gridData);
        this.populateOutputDirCombo();
        this.setControl((Control)container);
    }

    public void applyToData(Map<String, Object> data) throws Exception {
        this.paramPage.performOK();
        String projectRootLoc = this.project.getWorkspace().getRoot().getRawLocation().toOSString();
        LOG.debug((Object)("the output code gen location: " + projectRootLoc));
        Hashtable genParams = (Hashtable)data.get("DATA_GEN_PARAMS");
        genParams.put("TOOL_SPECIFIC_OPS", this.paramPage.getParameters());
        String strOutputDir = String.valueOf(projectRootLoc) + this.getOutputDir();
        genParams.put("GEN_OUTPUTDIR", strOutputDir);
        IPath newPath = this.possibleNewPaths.get(this.getOutputDir());
        if (newPath != null) {
            data.put("DATA_NEW_BUILD_PATH", new IPath[]{newPath});
        }
    }

    public void initializeFromData(Map data) throws Exception {
        this.project = (IProject)data.get("DATA_PROJECT");
        this.populateOutputDirCombo();
    }

    protected boolean validateInputs() {
        this.setErrorMessage(null);
        this.setMessage(null);
        String errMsg = this.paramPage.validateParams();
        if (errMsg != null) {
            this.setErrorMessage(this.paramPage.validateParams());
            return false;
        }
        return true;
    }

    public String getOutputDir() {
        return this.cboOutputDir.getText();
    }

    private void populateOutputDirCombo() {
        if (this.project == null) {
            return;
        }
        this.cboOutputDir.removeAll();
        this.possibleNewPaths.clear();
        IPath[] srcPaths = ScJDTUtils.getProjectSrcPaths(this.project);
        int i = 0;
        while (i < srcPaths.length) {
            if (!this.possibleNewPaths.containsKey(srcPaths[i].toOSString())) {
                this.cboOutputDir.add(srcPaths[i].toOSString());
            }
            ++i;
        }
        if (this.cboOutputDir.getItemCount() > 0) {
            this.cboOutputDir.select(0);
        }
    }
}

