package org.eclipse.stp.sc.jaxws.builders;

import java.util.List;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.RequestWrapper;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.stp.sc.common.annotations.ScAnnotationSupportUtils;
import org.eclipse.stp.sc.common.utils.JDTUtils;

public class JavaDocumentUtils {

    @SuppressWarnings("unchecked")
    public static boolean needToGenerateWrapper(ICompilationUnit compUnit) {
        if (compUnit == null) {
            return false;
        }
    
        List<Annotation> annotations = JDTUtils.getAnnotations(compUnit.findPrimaryType());
    
        if (annotations == null) {
            return false;
        }
    
        boolean rpcStyle = false;
        boolean literalUse = false;
        boolean isBare = false;
    
        for (Annotation an : annotations) {
            if (an.getTypeName().getFullyQualifiedName().equals(SOAPBinding.class.getSimpleName())) {
                NormalAnnotation normal = (NormalAnnotation)an;
                List<MemberValuePair> members = normal.values();
    
                for (MemberValuePair member : members) {
                    if (member.getName().getFullyQualifiedName().equals("use")) {
                        if (member.getValue().toString().toUpperCase().indexOf("LITERAL") >= 0) {
                            literalUse = true;
                        }
                    }
    
                    if (member.getName().getFullyQualifiedName().equals("style")) {
                        if (member.getValue().toString().toUpperCase().indexOf("RPC") >= 0) {
                            rpcStyle = true;
                        }
                    }
                    
                    if (member.getName().getFullyQualifiedName().equals("parameterStyle")) {
                        if (member.getValue().toString().toUpperCase().indexOf("BARE") >= 0) {
                        	isBare = true;
                        }
                    }
                }
                if (rpcStyle && literalUse) {
                	return false;
                }
                if (isBare) {
                	return false;
                }
            }
        }
        return true;
    }

    /**
     * check if the input java source file has @WebService annotation or not
     * @param javaFile,
     * @return true, found @WebService annotation
     */
    public static boolean hasWebServiceAnnotation(IFile javaFile) {
    	return JDTUtils.hasAnnotationOnPrimaryType(javaFile, WebService.class);
    }

    public static boolean hasWrapperAnnotation(ICompilationUnit compUnit)
        throws JavaModelException {
        IMethod[] methods = compUnit.findPrimaryType().getMethods();
    
        for (IMethod method : methods) {
            List<Annotation> annotations = JDTUtils.getAnnotations(method);
    
            for (Annotation an : annotations) {
                if (an.getTypeName().getFullyQualifiedName().equals(RequestWrapper.class.getSimpleName())) {
                    ScAnnotationSupportUtils.LOG.debug("find RequestWrapper method, need to generate wrapper classes for :"
                              + compUnit.getUnderlyingResource().getRawLocation().toOSString());
                    return true;
                }
            }
        }
    
        return false;
    }

}
