package org.eclipse.stp.sc.sca.java.utils;

import java.util.HashSet;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.stp.sc.common.annotations.ScAnnotationSupportUtils;
import org.eclipse.stp.sc.common.annotations.ScJDTAnnUtils;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.osoa.sca.annotations.Service;

public class ScaJDTUtils extends ScJDTAnnUtils {
		
	public static final HashSet<String> SCA_TABLE = new HashSet<String>();

    static {
    	SCA_TABLE.add("Remotable");
    	SCA_TABLE.add("Service");
    	SCA_TABLE.add("AllowsPassByReference");
    	SCA_TABLE.add("Callback");
    	SCA_TABLE.add("ComponentName");
    	SCA_TABLE.add("Constructor");
    	SCA_TABLE.add("Context");
    	SCA_TABLE.add("Destroy");
    	SCA_TABLE.add("Init");
    	SCA_TABLE.add("OneWay");
    	SCA_TABLE.add("Property");
    	SCA_TABLE.add("Reference");
    	SCA_TABLE.add("Scope");
    	SCA_TABLE.add("Session");
    	SCA_TABLE.add("SessionID");
    	SCA_TABLE.add("XmlAccessorType");
    }

    public static void addAnnotationImport(
			CompilationUnit compilationUnitAstNode, Annotation annotationNode,
			ASTRewrite rewrite) {
		String fullAnno = ScAnnotationSupportUtils
				.getAnnotationImport(annotationNode);

		if (fullAnno == null) {
			if (SCA_TABLE.contains(annotationNode.getTypeName().toString())) {
	            fullAnno = Service.class.getPackage().getName() + "." + annotationNode.getTypeName().toString();
	        }
		}

		if (fullAnno != null) {
			// usually happens when the annotation was manually added in the
			// code with its fully qualified name
			// (so no need for an import)
			JDTUtils.addImport(compilationUnitAstNode, fullAnno, rewrite);
		}
	}	
}
