/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.utils;

import java.io.File;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTUtils {
    public static final String JAVA_FILE_EXT = "java";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JDTUtils.class);

    protected JDTUtils() {
    }

    public static IPath getProjectOutputPath(IProject project) throws JavaModelException {
        IJavaProject javaProject = JDTUtils.findJavaProject(project.getName());
        return javaProject.getOutputLocation();
    }

    public static URL[] getProjectClasspath(IProject project) {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            String rootDir = workspace.getRoot().getLocation().toOSString();
            IJavaProject javaProject = JDTUtils.findJavaProject(project.getName());
            IClasspathEntry[] rawClassPath = javaProject.getResolvedClasspath(true);
            Path[] initClassPath = new Path[rawClassPath.length];
            int i = 0;
            while (i < rawClassPath.length) {
                initClassPath[i] = rawClassPath[i].getPath();
                ++i;
            }
            i = 0;
            while (i < initClassPath.length) {
                if (!(initClassPath[i].toOSString().startsWith(rootDir) || initClassPath[i].toFile().isFile() || initClassPath[i].toFile().isDirectory())) {
                    IResource res = workspace.getRoot().findMember((IPath)initClassPath[i]);
                    if (res != null && res.isLinked()) {
                        initClassPath[i] = res.getRawLocation();
                    } else {
                        Path classPathAfterProcess;
                        String classPathToProcess = initClassPath[i].toOSString();
                        initClassPath[i] = classPathAfterProcess = new Path(String.valueOf(rootDir) + File.separator + classPathToProcess);
                    }
                }
                ++i;
            }
            String outputDir = String.valueOf(rootDir) + File.separator + javaProject.getOutputLocation().toOSString();
            File outputClassPath = new File(outputDir);
            URL[] targetClassPath = new URL[initClassPath.length + 1];
            targetClassPath[0] = outputClassPath.toURL();
            int i2 = 0;
            while (i2 < initClassPath.length) {
                File tempClassPath = new File(initClassPath[i2].toOSString());
                targetClassPath[i2 + 1] = tempClassPath.toURL();
                ++i2;
            }
            return targetClassPath;
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static String getProjectClasspathAsString(IProject project) {
        URL[] projectClasspaths = JDTUtils.getProjectClasspath(project);
        if (projectClasspaths == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        URL[] uRLArray = projectClasspaths;
        int n = 0;
        int n2 = uRLArray.length;
        while (n < n2) {
            URL url = uRLArray[n];
            String strClasspath = url.getFile();
            String os = System.getProperty("os.name");
            if (os.indexOf("Window") >= 0) {
                strClasspath = strClasspath.substring(1);
                strClasspath = strClasspath.replace('/', '\\');
            } else {
                strClasspath = strClasspath.replace('\\', '/');
            }
            sb.append(strClasspath);
            sb.append(File.pathSeparator);
            ++n;
        }
        return sb.toString();
    }

    public static ICompilationUnit findUnitByFileName(IJavaElement javaElem, String filePath) throws Exception {
        ICompilationUnit unit = null;
        if (!javaElem.getOpenable().isOpen()) {
            javaElem.getOpenable().open(null);
        }
        IJavaElement[] elems = null;
        if (javaElem instanceof IParent) {
            IParent parent = (IParent)javaElem;
            elems = parent.getChildren();
        }
        if (elems == null) {
            return null;
        }
        IJavaElement[] iJavaElementArray = elems;
        int n = 0;
        int n2 = iJavaElementArray.length;
        while (n < n2) {
            ICompilationUnit compUnit;
            IJavaElement elem = iJavaElementArray[n];
            if (elem.getElementType() == 3) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)elem;
                if (root.getKind() == 1 && (unit = JDTUtils.findUnitByFileName(elem, filePath)) != null) {
                    return unit;
                }
            } else if (elem.getElementType() == 4 || elem.getElementType() == 2) {
                unit = JDTUtils.findUnitByFileName(elem, filePath);
                if (unit != null) {
                    return unit;
                }
            } else if (elem.getElementType() == 5 && (compUnit = (ICompilationUnit)elem).getPath().toString().equals(filePath)) {
                compUnit.open(null);
                return compUnit;
            }
            ++n;
        }
        return null;
    }

    public static IJavaProject getJavaProjectByName(String projectName) throws JavaModelException {
        IJavaProject[] projects;
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        model.open(null);
        IJavaProject[] iJavaProjectArray = projects = model.getJavaProjects();
        int n = 0;
        int n2 = iJavaProjectArray.length;
        while (n < n2) {
            IJavaProject proj = iJavaProjectArray[n];
            if (proj.getProject().getName().equals(projectName)) {
                return proj;
            }
            ++n;
        }
        return null;
    }

    public static ICompilationUnit getJavaUnitFromFile(IFile javaFile) {
        IJavaProject project;
        block3: {
            try {
                project = JDTUtils.getJavaProjectByName(javaFile.getProject().getName());
                if (project != null) break block3;
                return null;
            }
            catch (Exception e) {
                LOG.error((Object)"", (Throwable)e);
                return null;
            }
        }
        return JDTUtils.findUnitByFileName((IJavaElement)project, javaFile.getFullPath().toString());
    }

    public static String getJavaClassNameFromFile(IFile javaFile) {
        try {
            ICompilationUnit javaUnit = JDTUtils.getJavaUnitFromFile(javaFile);
            String clsName = "";
            IPackageDeclaration[] pkgs = javaUnit.getPackageDeclarations();
            if (pkgs != null && pkgs.length > 0) {
                clsName = pkgs[0].getElementName();
                clsName = String.valueOf(clsName) + "." + javaUnit.getElementName().substring(0, javaUnit.getElementName().lastIndexOf("."));
            } else {
                clsName = javaUnit.getElementName().substring(0, javaUnit.getElementName().lastIndexOf("."));
            }
            return clsName;
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static CompilationUnit getDomRootCompilationUnit(IMember jdtMember) {
        return JDTUtils.getDomRootCompilationUnit(jdtMember.getCompilationUnit());
    }

    public static CompilationUnit getDomRootCompilationUnit(ICompilationUnit unit) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(unit);
        return (CompilationUnit)parser.createAST(null);
    }

    public static List<Annotation> getParameterAnnotations(CompilationUnit compilationUnitAstNode, IMethod method, String parameterName) {
        SingleVariableDeclaration methodParamDecl = JDTUtils.getMethodParamDeclaration(compilationUnitAstNode, method, parameterName);
        return methodParamDecl == null ? null : JDTUtils.getAnnotationsFromParamDecl(methodParamDecl);
    }

    public static SingleVariableDeclaration getMethodParamDeclaration(CompilationUnit compilationUnitAstNode, IMethod method, String parameterName) {
        BodyDeclaration bd = JDTUtils.getBodyDeclaration(compilationUnitAstNode, (IMember)method);
        if (!(bd instanceof MethodDeclaration)) {
            return null;
        }
        MethodDeclaration methodDesc = (MethodDeclaration)bd;
        Iterator paraItor = methodDesc.parameters().iterator();
        SingleVariableDeclaration methodParamDecl = null;
        while (paraItor.hasNext()) {
            SingleVariableDeclaration desc = (SingleVariableDeclaration)paraItor.next();
            if (!desc.getName().getIdentifier().equals(parameterName)) continue;
            methodParamDecl = desc;
        }
        return methodParamDecl;
    }

    public static List<Annotation> getAnnotationsFromParamDecl(SingleVariableDeclaration desc) {
        return JDTUtils.getAnnotationListFromModifier(desc.modifiers());
    }

    private static BodyDeclaration getBodyDeclaration(IMember jdtMember) {
        return JDTUtils.getBodyDeclaration(JDTUtils.getDomRootCompilationUnit(jdtMember), jdtMember);
    }

    public static BodyDeclaration getBodyDeclaration(CompilationUnit compilationUnitAstNode, IMember jdtMember) {
        if (jdtMember == null) {
            return null;
        }
        String parentTypeName = jdtMember.getDeclaringType() != null ? jdtMember.getDeclaringType().getElementName() : jdtMember.getElementName();
        String seekedDeclarationName = jdtMember.getElementName();
        for (TypeDeclaration td : compilationUnitAstNode.types()) {
            String tname = td.getName().getIdentifier();
            if (!tname.equals(parentTypeName)) continue;
            if (seekedDeclarationName.equals(tname)) {
                return td;
            }
            FieldDeclaration[] fields = td.getFields();
            int inx = 0;
            while (inx < fields.length) {
                fields[inx].fragments();
                Iterator j = fields[inx].fragments().iterator();
                while (j.hasNext()) {
                    String name = ((VariableDeclarationFragment)j.next()).getName().getIdentifier();
                    if (!seekedDeclarationName.equals(name)) continue;
                    return fields[inx];
                }
                ++inx;
            }
            MethodDeclaration[] methods = td.getMethods();
            int inx2 = 0;
            while (inx2 < methods.length) {
                if (seekedDeclarationName.equals(methods[inx2].getName().getIdentifier())) {
                    return methods[inx2];
                }
                ++inx2;
            }
            LOG.debug((Object)("the specified IMember '" + jdtMember.getElementName() + "' was neither a class, nor a method, nor an attribute declaration"));
            return null;
        }
        LOG.debug((Object)("no containing declaration element was found the specified IMember '" + jdtMember.getElementName() + "'."));
        return null;
    }

    public static Document getJavaDocumentCopy(IMember jdtMember) {
        try {
            return new Document(jdtMember.getCompilationUnit().getBuffer().getContents());
        }
        catch (JavaModelException e) {
            LOG.error((Object)("couldn't retrieve the jface.text.Document for the java member: " + jdtMember.getElementName()), (Throwable)e);
            return null;
        }
    }

    public static List<Annotation> getAnnotations(BodyDeclaration bodyDecl) {
        if (bodyDecl == null) {
            return new ArrayList<Annotation>(0);
        }
        return JDTUtils.getAnnotationListFromModifier(bodyDecl.modifiers());
    }

    private static List<Annotation> getAnnotationListFromModifier(List modifier) {
        ArrayList<Annotation> annotationNodesList = new ArrayList<Annotation>(modifier.size());
        for (Object currentModifier : modifier) {
            if (!(currentModifier instanceof Annotation)) continue;
            annotationNodesList.add((Annotation)currentModifier);
        }
        return annotationNodesList;
    }

    public static List<Annotation> getAnnotations(CompilationUnit compilationUnitAstNode, IMember jdtMember) {
        return JDTUtils.getAnnotations(JDTUtils.getBodyDeclaration(compilationUnitAstNode, jdtMember));
    }

    public static List<Annotation> getAnnotations(IMember jdtMember) {
        if (jdtMember == null) {
            return null;
        }
        return JDTUtils.getAnnotations(JDTUtils.getBodyDeclaration(jdtMember));
    }

    public static boolean hasAnnotation(IMember member, Annotation annotationNode) {
        String annotName = JDTUtils.getBasicAnnotName(annotationNode);
        for (Object o : JDTUtils.getBodyDeclaration(member).modifiers()) {
            String name;
            if (!(o instanceof Annotation) || !(name = JDTUtils.getBasicAnnotName((Annotation)o)).equals(annotName)) continue;
            return true;
        }
        return false;
    }

    public static Annotation findAnnotation(CompilationUnit compilationUnitAstNode, IMember member, Annotation annotationNode) {
        return JDTUtils.findAnnotation(JDTUtils.getAnnotations(compilationUnitAstNode, member), annotationNode);
    }

    public static Annotation findAnnotation(List list, Annotation annotationNode) {
        String annotName = JDTUtils.getBasicAnnotName(annotationNode);
        for (Object o : list) {
            String name;
            if (!(o instanceof Annotation) || !(name = JDTUtils.getBasicAnnotName((Annotation)o)).equals(annotName)) continue;
            return (Annotation)o;
        }
        return null;
    }

    public static String getBasicAnnotName(Annotation annotationNode) {
        Name typeName = annotationNode.getTypeName();
        String basicName = typeName.getFullyQualifiedName();
        if (typeName.isQualifiedName()) {
            basicName = ((QualifiedName)typeName).getName().getFullyQualifiedName();
        }
        return basicName;
    }

    public static NormalAnnotation newNormalAnnotation(CompilationUnit compilationUnitAstNode, String name, List valuePairs) {
        AST ast = compilationUnitAstNode.getAST();
        NormalAnnotation normAnnotation = ast.newNormalAnnotation();
        Name typeName = ast.newName(name);
        normAnnotation.setTypeName(typeName);
        if (valuePairs != null) {
            int i = 0;
            while (i < valuePairs.size()) {
                if (valuePairs.get(i) instanceof MemberValuePair) {
                    MemberValuePair memberValuePair = (MemberValuePair)valuePairs.get(i);
                    ((AbstractList)normAnnotation.values()).add(memberValuePair);
                }
                ++i;
            }
        }
        return normAnnotation;
    }

    public static SingleMemberAnnotation newSingleMemberAnnotation(CompilationUnit compilationUnitAstNode, String name, Expression exp) {
        AST ast = compilationUnitAstNode.getAST();
        SingleMemberAnnotation singleAnnotation = ast.newSingleMemberAnnotation();
        Name typeName = ast.newName(name);
        singleAnnotation.setTypeName(typeName);
        singleAnnotation.setValue(exp);
        return singleAnnotation;
    }

    private static SimpleType convertPrimitiveTypeToSimple(AST ast, PrimitiveType primitive) {
        String clsName = "";
        if (primitive.getPrimitiveTypeCode().equals(PrimitiveType.BYTE)) {
            clsName = Byte.class.getName();
        } else if (primitive.getPrimitiveTypeCode().equals(PrimitiveType.BOOLEAN)) {
            clsName = Boolean.class.getName();
        } else if (primitive.getPrimitiveTypeCode().equals(PrimitiveType.CHAR)) {
            clsName = Character.class.getName();
        } else if (primitive.getPrimitiveTypeCode().equals(PrimitiveType.DOUBLE)) {
            clsName = Double.class.getName();
        } else if (primitive.getPrimitiveTypeCode().equals(PrimitiveType.FLOAT)) {
            clsName = Float.class.getName();
        } else if (primitive.getPrimitiveTypeCode().equals(PrimitiveType.INT)) {
            clsName = Integer.class.getName();
        } else if (primitive.getPrimitiveTypeCode().equals(PrimitiveType.LONG)) {
            clsName = Long.class.getName();
        } else if (primitive.getPrimitiveTypeCode().equals(PrimitiveType.SHORT)) {
            clsName = Short.class.getName();
        } else {
            return null;
        }
        clsName = clsName.substring(clsName.lastIndexOf(".") + 1);
        SimpleName sName = ast.newSimpleName(clsName);
        return ast.newSimpleType((Name)sName);
    }

    public static MemberValuePair newMemberValuePair(CompilationUnit compilationUnitAstNode, String name, Object value) {
        return JDTUtils.newMemberValuePair(compilationUnitAstNode.getAST(), name, value, false);
    }

    public static MemberValuePair newMemberValuePair(CompilationUnit compilationUnitAstNode, String name, Object value, boolean convertPrimitiveType) {
        return JDTUtils.newMemberValuePair(compilationUnitAstNode.getAST(), name, value, convertPrimitiveType);
    }

    private static MemberValuePair newMemberValuePair(AST ast, String name, Object value, boolean convertPrimitiveType) {
        MemberValuePair valPair = ast.newMemberValuePair();
        valPair.setName(ast.newSimpleName(name));
        StringLiteral exp = null;
        if (value instanceof String) {
            StringLiteral sl = ast.newStringLiteral();
            sl.setLiteralValue((String)value);
            exp = sl;
        } else if (value instanceof Boolean) {
            exp = ast.newBooleanLiteral(((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            exp = ast.newNumberLiteral(((Long)value).toString());
        } else if (value instanceof Integer) {
            exp = ast.newNumberLiteral(((Integer)value).toString());
        } else if (value instanceof Double) {
            exp = ast.newNumberLiteral(((Double)value).toString());
        } else if (value instanceof Float) {
            exp = ast.newNumberLiteral(((Float)value).toString());
        } else if (value instanceof Type) {
            TypeLiteral tl = ast.newTypeLiteral();
            Type type = (Type)value;
            value = JDTUtils.createType(ast, name, type, convertPrimitiveType);
            tl.setType((Type)value);
            exp = tl;
        } else if (value.getClass().isArray()) {
            String[] strings = (String[])value;
            ArrayInitializer arrayInit = ast.newArrayInitializer();
            List expList = arrayInit.expressions();
            String[] stringArray = strings;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String str = stringArray[n];
                StringLiteral sl = ast.newStringLiteral();
                sl.setLiteralValue(str);
                expList.add(sl);
                ++n;
            }
            exp = arrayInit;
        } else if (value.getClass().isEnum()) {
            LOG.debug((Object)"handling enum attribute");
            SimpleName enumName = null;
            if (value.getClass().isMemberClass()) {
                enumName = ast.newSimpleName(value.getClass().getEnclosingClass().getSimpleName());
                enumName = ast.newQualifiedName((Name)enumName, ast.newSimpleName(value.getClass().getSimpleName()));
            } else {
                enumName = ast.newSimpleName(value.getClass().getSimpleName());
            }
            enumName = ast.newQualifiedName((Name)enumName, ast.newSimpleName(value.toString()));
            exp = enumName;
        } else if (value instanceof Class) {
            LOG.debug((Object)"handling class attribute");
            exp = JDTUtils.createTypeLiteralFromClass(ast, ((Class)value).getCanonicalName());
        }
        valPair.setValue((Expression)exp);
        return valPair;
    }

    private static Type createType(AST ast, String name, Type type, boolean convertPrimitiveType) {
        SimpleType value = null;
        if (type.isArrayType()) {
            Type compType = ((ArrayType)type).getComponentType();
            Type newCompType = JDTUtils.createType(ast, name, compType, convertPrimitiveType);
            value = ast.newArrayType(newCompType);
        } else if (type.isParameterizedType()) {
            ParameterizedType pt = (ParameterizedType)type;
            System.err.println("pt type:" + pt.getType());
            System.err.println("pt args type:" + pt.typeArguments().get(0));
            Type newParmType = JDTUtils.createType(ast, name, (Type)pt.typeArguments().get(0), convertPrimitiveType);
            value = ast.newParameterizedType(newParmType);
        } else if (type.isPrimitiveType()) {
            if (convertPrimitiveType) {
                value = JDTUtils.convertPrimitiveTypeToSimple(ast, (PrimitiveType)type);
            } else {
                PrimitiveType pType = (PrimitiveType)type;
                value = ast.newPrimitiveType(pType.getPrimitiveTypeCode());
            }
        } else if (type.isQualifiedType()) {
            value = ast.newQualifiedType(type, ast.newSimpleName(name));
        } else if (type.isSimpleType()) {
            SimpleType st = (SimpleType)type;
            SimpleName sName = ast.newSimpleName(st.getName().getFullyQualifiedName());
            value = ast.newSimpleType((Name)sName);
        }
        return value;
    }

    public static void addImport(CompilationUnit compilationUnitAstNode, String importStatement, ASTRewrite rewrite) {
        for (ImportDeclaration imp : compilationUnitAstNode.imports()) {
            if (!imp.getName().getFullyQualifiedName().equals(importStatement)) continue;
            return;
        }
        ImportDeclaration imp = compilationUnitAstNode.getAST().newImportDeclaration();
        Name impname = compilationUnitAstNode.getAST().newName(importStatement);
        imp.setName(impname);
        ListRewrite lrw1 = rewrite.getListRewrite((ASTNode)compilationUnitAstNode, CompilationUnit.IMPORTS_PROPERTY);
        lrw1.insertLast((ASTNode)imp, null);
    }

    public static void addAnnotationImport(CompilationUnit compilationUnitAstNode, Annotation annotationNode, ASTRewrite rewrite) {
        Exception e = new Exception();
        e.printStackTrace();
    }

    public static FieldDeclaration getFieldDeclaration(CompilationUnit compilationUnitAstNode, IField field) {
        IType type = field.getDeclaringType();
        for (TypeDeclaration t : compilationUnitAstNode.types()) {
            if (!t.getName().getIdentifier().equals(type.getElementName())) continue;
            String fieldName = field.getElementName();
            FieldDeclaration[] fields = t.getFields();
            int inx = 0;
            while (inx < fields.length) {
                VariableDeclarationFragment variable = (VariableDeclarationFragment)fields[inx].fragments().get(0);
                if (variable.getName().getIdentifier().equals(fieldName)) {
                    return fields[inx];
                }
                ++inx;
            }
        }
        return null;
    }

    public static void removeAnnotationOnField(CompilationUnit compilationUnitAstNode, Annotation annotationNode, IField field, ASTRewrite rewrite) {
        IType type = field.getDeclaringType();
        for (TypeDeclaration t : compilationUnitAstNode.types()) {
            if (!t.getName().getIdentifier().equals(type.getElementName())) continue;
            FieldDeclaration[] fields = t.getFields();
            String fieldName = field.getElementName();
            int inx = 0;
            while (inx < fields.length) {
                for (Object obj : fields[inx].fragments()) {
                    ListRewrite lrw2;
                    Annotation annot;
                    VariableDeclarationFragment var = (VariableDeclarationFragment)obj;
                    if (!var.getName().getFullyQualifiedName().equals(fieldName) || (annot = JDTUtils.findAnnotation((lrw2 = rewrite.getListRewrite((ASTNode)fields[inx], FieldDeclaration.MODIFIERS2_PROPERTY)).getOriginalList(), annotationNode)) == null) continue;
                    lrw2.remove((ASTNode)annot, null);
                }
                ++inx;
            }
        }
    }

    public static void removeAnnotationOnMethod(CompilationUnit compilationUnitAstNode, Annotation annotationNode, IMethod method, ASTRewrite rewrite) {
        IType type = method.getDeclaringType();
        for (TypeDeclaration t : compilationUnitAstNode.types()) {
            if (!t.getName().getIdentifier().equals(type.getElementName())) continue;
            MethodDeclaration[] meths = t.getMethods();
            String methodName = method.getElementName();
            int inx = 0;
            while (inx < meths.length) {
                ListRewrite lrw2;
                Annotation annot;
                if (meths[inx].getName().getIdentifier().equals(methodName) && (annot = JDTUtils.findAnnotation((lrw2 = rewrite.getListRewrite((ASTNode)meths[inx], MethodDeclaration.MODIFIERS2_PROPERTY)).getOriginalList(), annotationNode)) != null) {
                    lrw2.remove((ASTNode)annot, null);
                }
                ++inx;
            }
        }
    }

    public static void removeAnnotationOnMethodParam(CompilationUnit compilationUnitAstNode, Annotation annotationNode, SingleVariableDeclaration memberParam, ASTRewrite rewrite) {
        ListRewrite lrw2 = rewrite.getListRewrite((ASTNode)memberParam, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
        Annotation annot = JDTUtils.findAnnotation(lrw2.getOriginalList(), annotationNode);
        if (annot != null) {
            lrw2.remove((ASTNode)annot, null);
        }
    }

    public static void removeAnnotationOnType(CompilationUnit compilationUnitAstNode, Annotation annotationNode, IType type, ASTRewrite rewrite) {
        for (TypeDeclaration t : compilationUnitAstNode.types()) {
            ListRewrite lrw2;
            Annotation annot;
            if (!t.getName().getIdentifier().equals(type.getElementName()) || (annot = JDTUtils.findAnnotation((lrw2 = rewrite.getListRewrite((ASTNode)t, TypeDeclaration.MODIFIERS2_PROPERTY)).getOriginalList(), annotationNode)) == null) continue;
            lrw2.remove((ASTNode)annot, null);
        }
    }

    public static IJavaElement getJavaElementFromFile(IFile javaFile, int offset) {
        LOG.debug((Object)("Getting element from file: " + javaFile));
        if (javaFile == null || !javaFile.getFileExtension().equals(JAVA_FILE_EXT)) {
            return null;
        }
        try {
            ICompilationUnit compilationUnitMember = JDTUtils.getJavaUnitFromFile(javaFile);
            IJavaElement element = compilationUnitMember.getElementAt(offset);
            LOG.debug((Object)("selected offset:" + offset));
            LOG.debug((Object)("selected java element:" + element));
            return element;
        }
        catch (JavaModelException e) {
            LOG.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static SingleVariableDeclaration getMethodParamDeclaration(CompilationUnit compilationUnitAstNode, IMethod method, int offset) {
        MethodDeclaration methodDesc = compilationUnitAstNode == null ? (MethodDeclaration)JDTUtils.getBodyDeclaration((IMember)method) : (MethodDeclaration)JDTUtils.getBodyDeclaration(compilationUnitAstNode, (IMember)method);
        for (SingleVariableDeclaration desc : methodDesc.parameters()) {
            int srcRangeOffset = desc.getStartPosition();
            int srcRangeLentgh = desc.getLength();
            if (offset < srcRangeOffset || offset > srcRangeOffset + srcRangeLentgh) continue;
            return desc;
        }
        return null;
    }

    public static String findImplClsName(IProject project, String interfaceName) {
        try {
            IType[] types;
            IType ifType = JDTUtils.findTypeByName(project, interfaceName);
            ITypeHierarchy hierarchy = ifType.newTypeHierarchy(null);
            IType[] iTypeArray = types = hierarchy.getImplementingClasses(ifType);
            int n = 0;
            int n2 = iTypeArray.length;
            if (n < n2) {
                IType type = iTypeArray[n];
                return String.valueOf(type.getPackageFragment().getElementName()) + "." + type.getElementName();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
        return null;
    }

    public static IType findTypeByName(IProject project, String clsName) {
        IType type = null;
        try {
            IJavaProject javaProject = JDTUtils.getJavaProjectByName(project.getName());
            LOG.debug((Object)("try to find type:" + clsName));
            return javaProject.findType(clsName);
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
            return type;
        }
    }

    public static IJavaProject findJavaProject(String projectName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)workspace.getRoot());
        return javaModel.getJavaProject(projectName);
    }

    public static void removeAnnotationFromCu(ICompilationUnit compilationUnitMember, CompilationUnit compilationUnitAstNode, Annotation annotationNode, IMember member, SingleVariableDeclaration methodParam) throws JavaModelException, MalformedTreeException, BadLocationException {
        ArrayList<Annotation> annotationNodes = new ArrayList<Annotation>(1);
        annotationNodes.add(annotationNode);
        JDTUtils.removeAnnotationsFromCu(compilationUnitMember, compilationUnitAstNode, annotationNodes, member, methodParam);
    }

    public static void removeAnnotationsFromCu(ICompilationUnit compilationUnitMember, CompilationUnit compilationUnitAstNode, List<Annotation> annotationNodes, IMember member, SingleVariableDeclaration methodParam) throws JavaModelException, MalformedTreeException, BadLocationException {
        String source = compilationUnitMember.getBuffer().getContents();
        Document document = new Document(source);
        ASTRewrite rewrite = ASTRewrite.create((AST)compilationUnitAstNode.getAST());
        for (Annotation currentAnnotationNode : annotationNodes) {
            if (member instanceof IField) {
                JDTUtils.removeAnnotationOnField(compilationUnitAstNode, currentAnnotationNode, (IField)member, rewrite);
                continue;
            }
            if (methodParam != null) {
                JDTUtils.removeAnnotationOnMethodParam(compilationUnitAstNode, currentAnnotationNode, methodParam, rewrite);
                continue;
            }
            if (member instanceof IMethod && methodParam == null) {
                JDTUtils.removeAnnotationOnMethod(compilationUnitAstNode, currentAnnotationNode, (IMethod)member, rewrite);
                continue;
            }
            if (!(member instanceof IType)) continue;
            JDTUtils.removeAnnotationOnType(compilationUnitAstNode, currentAnnotationNode, (IType)member, rewrite);
        }
        TextEdit edits = rewrite.rewriteAST((IDocument)document, compilationUnitMember.getJavaProject().getOptions(true));
        edits.apply((IDocument)document);
        compilationUnitMember.getBuffer().setContents(document.get());
    }

    public static String getNamespace(String packageName) {
        String[] tokens;
        StringTokenizer tokenizer;
        if (packageName == null || packageName.length() == 0) {
            packageName = "default_package";
        }
        if ((tokenizer = new StringTokenizer(packageName, ".")).countTokens() == 0) {
            tokens = new String[]{};
        } else {
            tokens = new String[tokenizer.countTokens()];
            int i = tokenizer.countTokens() - 1;
            while (i >= 0) {
                tokens[i] = tokenizer.nextToken();
                --i;
            }
        }
        StringBuffer namespace = new StringBuffer("http://");
        String dot = "";
        int i = 0;
        while (i < tokens.length) {
            if (i == 1) {
                dot = ".";
            }
            namespace.append(String.valueOf(dot) + tokens[i]);
            ++i;
        }
        namespace.append('/');
        return namespace.toString();
    }

    public static TypeLiteral createTypeLiteralFromClass(AST ast, String classCanonicalName) {
        int previousIndex = -1;
        SimpleType theType = null;
        if (classCanonicalName.indexOf(".") > 0) {
            String substring;
            int nextIndex = classCanonicalName.indexOf(46);
            theType = ast.newSimpleType((Name)ast.newSimpleName(classCanonicalName.substring(1 + previousIndex, nextIndex)));
            previousIndex = nextIndex;
            nextIndex = classCanonicalName.indexOf(46, previousIndex + 1);
            while (nextIndex != -1) {
                substring = classCanonicalName.substring(1 + previousIndex, nextIndex);
                theType = ast.newQualifiedType((Type)theType, ast.newSimpleName(substring));
                previousIndex = nextIndex;
                nextIndex = classCanonicalName.indexOf(46, previousIndex + 1);
            }
            substring = classCanonicalName.substring(1 + previousIndex);
            theType = ast.newQualifiedType((Type)theType, ast.newSimpleName(substring));
        } else {
            theType = ast.newSimpleType((Name)ast.newSimpleName(classCanonicalName));
        }
        TypeLiteral typeLiteral = ast.newTypeLiteral();
        typeLiteral.setType((Type)theType);
        return typeLiteral;
    }

    public static boolean hasAnnotationOnPrimaryType(IFile javaFile, Class cls) {
        ICompilationUnit compUnit = JDTUtils.getJavaUnitFromFile(javaFile);
        if (compUnit == null) {
            return false;
        }
        List<Annotation> annotations = JDTUtils.getAnnotations((IMember)compUnit.findPrimaryType());
        if (compUnit == null) {
            return false;
        }
        if (annotations == null) {
            return false;
        }
        for (Annotation an : annotations) {
            if (!an.getTypeName().getFullyQualifiedName().equals(cls.getSimpleName()) && !an.getTypeName().getFullyQualifiedName().equals(cls.getName())) continue;
            return true;
        }
        return false;
    }
}

