/*******************************************************************************

* Copyright (c) 2007 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.common.runtimeintegrator;

import java.util.HashMap;

/**
 * @author jma
 *
 */
public class ExtGeneratorTool {
    String id;
    String toolType;
    IParameterPage parameterPage = null;
    IGeneratorTool toolClass = null;
    HashMap<String, String> configParamTab = new HashMap<String, String>();
    
    public void addConfigParam(String paramName, String paramValue) {
        configParamTab.put(paramName, paramValue);
    }
    
    public HashMap getAllConfigParams() {
        return configParamTab;
    }
    
    public String getConfigParam(String paramName) {
        return configParamTab.get(paramName);
    }
    
    public String getId() {
        return id;
    }
    public void setId(String id) {
        this.id = id;
    }
    public IParameterPage getParameterPage() {
        return parameterPage;
    }
    public void setParameterPage(IParameterPage parameterPage) {
        this.parameterPage = parameterPage;
    }
    public IGeneratorTool getToolClass() {
        return toolClass;
    }
    public void setToolClass(IGeneratorTool toolClass) {
        this.toolClass = toolClass;
    }
    public String getToolType() {
        return toolType;
    }
    public void setToolType(String toolType) {
        this.toolType = toolType;
    }
    
}
