/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.xmlvalidator.classbuilder;

import java.lang.reflect.Array;

/**
 * @author jma
 * 
 */
public class ByteCodeUtils {
	public static String toHexString(byte bytes[]) {
		StringBuffer retString = new StringBuffer();
		for (int i = 0; i < bytes.length; ++i)
		{
			retString.append("0x"+
				Integer.toHexString(0x0100 + (bytes[i] & 0x00FF)).substring(1));
			retString.append(" ");
		}
		return retString.toString();
	}
	
	public static String toHexString(byte byteValue) {
		return "0x" +  Integer.toHexString(0x0100 + (byteValue & 0x00FF)).substring(1);
	}


    public static String getMethodDescriptor(JMethod method) {
		StringBuilder sb = new StringBuilder("(");
		for (JParam param : method.getParameters()) {
			sb.append(getClassCode(param.getType()));
		}
		sb.append(")");
                if (method.getReturnType() == null) {
                    sb.append("V");
                } else {
                    sb.append(getClassCode(method.getReturnType()));
                }
		return sb.toString();
	}
    
    public static String getFieldDescriptor(JField field) {
    	Class<?> type = field.getType();
    	return getFieldDescriptor(type);
    }
    
    public static String getFieldDescriptor(Class<?> type) {
      	String typeName = type.getName();
    	//Base Type
    	if (typeName.equals(byte.class.getName())) {
    		return "B";
    	} 
    	if (typeName.equals(char.class.getName())) {
    		return "C";
    	}
    	if (typeName.equals(double.class.getName())) {
    		return "D";
    	}
    	if (typeName.equals(float.class.getName())) {
    		return "F";
    	}
    	if (typeName.equals(int.class.getName())) {
    		return "I";
    	}
    	if (typeName.equals(long.class.getName())){
    		return "J";
    	}    	
    	if (typeName.equals(short.class.getName())) {
    		return "S";
    	}
    	if (typeName.equals(boolean.class.getName())) {
    		return "Z";
    	}
    	//Array Type
    	if (type.isArray()) {
    		String arrayType = "[";
    		try {
    		    Class<?> arrayClass = Class.forName(typeName.substring(1));
    		    arrayType += getFieldDescriptor(arrayClass);
    		} catch (Exception e) {
    			e.printStackTrace();
    		}
    		return arrayType;
    	}
    	//Object Type
    	String ret = "L";
    	ret = ret + type.getName().replace('.', '/');
    	ret += ";";
    	return ret;
    }

	public static String getClassCode(Class<?> c) {
		if (c == void.class)
			return "V";
		Class<?> arrayClass = Array.newInstance(c, 0).getClass();
		return arrayClass.getName().substring(1).replace('.', '/');
	}
}
