/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.models.deployfile.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.deploy.models.deployfile.provider.DeployFileItemProviderAdapterFactory;

public class Utilities {
    public static final String CMD_LABEL_ADD_TARGET = "Add Target";
    public static final String CMD_DESC_ADD_TARGET = "Adds a new target to the package";
    public static final String CMD_LABEL_SET_TARGET = "Set Target";
    public static final String CMD_DESC_SET_TARGET = "Changes the target server";
    private static List sItemAdapterFactories = null;
    private static ComposedAdapterFactory sItemAdapterFactory = null;

    public static List getItemAdapterFactoriesList() {
        if (sItemAdapterFactories == null) {
            sItemAdapterFactories = new Vector(2);
            sItemAdapterFactories.add(new ResourceItemProviderAdapterFactory());
            sItemAdapterFactories.add(new DeployFileItemProviderAdapterFactory());
        }
        return sItemAdapterFactories;
    }

    public static ComposedAdapterFactory getItemAdapterFactory() {
        if (sItemAdapterFactory == null) {
            sItemAdapterFactory = new ComposedAdapterFactory((Collection)Utilities.getItemAdapterFactoriesList());
        }
        return sItemAdapterFactory;
    }

    public static void fixServerReferences(Root root) {
        EList servers = root.getServer();
        Iterator svrIt = servers.iterator();
        while (svrIt.hasNext()) {
            DeployServer server = (DeployServer)svrIt.next();
            EList configs = server.getTargetingConfiguration();
            Iterator cfgIt = configs.iterator();
            while (cfgIt.hasNext()) {
                DeployConfiguration config = (DeployConfiguration)cfgIt.next();
                if (config.getSourcePackage() != null && root.equals(config.getSourcePackage().getRoot())) continue;
                cfgIt.remove();
            }
            if (server.getTargetingConfiguration().size() != 0) continue;
            svrIt.remove();
        }
    }

    public static Command createAddTargetCommand(EditingDomain domain, DeployPackage pkg, String target) {
        Vector<Command> commandList = new Vector<Command>(3);
        DeployServer server = DeployFilePackage.eINSTANCE.getDeployFileFactory().createDeployServer(target);
        DeployConfiguration config = DeployFilePackage.eINSTANCE.getDeployFileFactory().createDeployConfiguration();
        Command addServer = AddCommand.create((EditingDomain)domain, (Object)pkg.getRoot(), (Object)DeployFilePackage.eINSTANCE.getRoot_Server(), (Object)server);
        Command addConfig = AddCommand.create((EditingDomain)domain, (Object)pkg, (Object)DeployFilePackage.eINSTANCE.getDeployPackage_TargetConfiguration(), (Object)config);
        Command setTarget = SetCommand.create((EditingDomain)domain, (Object)config, (Object)DeployFilePackage.eINSTANCE.getDeployConfiguration_TargetServer(), (Object)server);
        commandList.add(addServer);
        commandList.add(addConfig);
        commandList.add(setTarget);
        return new CompoundCommand(CMD_LABEL_ADD_TARGET, CMD_DESC_ADD_TARGET, commandList);
    }

    public static Command createAddDeployConfigurationCommand(EditingDomain domain, DeployPackage pkg, DeployServer target) {
        Vector<Command> commandList = new Vector<Command>(3);
        DeployConfiguration config = DeployFilePackage.eINSTANCE.getDeployFileFactory().createDeployConfiguration();
        commandList.add(AddCommand.create((EditingDomain)domain, (Object)pkg, (Object)DeployFilePackage.eINSTANCE.getDeployPackage_TargetConfiguration(), (Object)config));
        commandList.add(SetCommand.create((EditingDomain)domain, (Object)config, (Object)DeployFilePackage.eINSTANCE.getDeployConfiguration_TargetServer(), (Object)target));
        if (target.getRoot() == null && pkg.getRoot() != null) {
            commandList.add(AddCommand.create((EditingDomain)domain, (Object)pkg.getRoot(), (Object)DeployFilePackage.eINSTANCE.getRoot_Server(), (Object)target));
        }
        return new CompoundCommand(CMD_LABEL_ADD_TARGET, CMD_DESC_ADD_TARGET, commandList);
    }

    public static Command createSetNewTargetCommand(EditingDomain domain, DeployConfiguration config, String target) {
        Vector<Command> commandList = new Vector<Command>(2);
        DeployServer server = DeployFilePackage.eINSTANCE.getDeployFileFactory().createDeployServer(target);
        Command addServer = AddCommand.create((EditingDomain)domain, (Object)config.getSourcePackage().getRoot(), (Object)DeployFilePackage.eINSTANCE.getRoot_Server(), (Object)server);
        Command setTarget = SetCommand.create((EditingDomain)domain, (Object)config, (Object)DeployFilePackage.eINSTANCE.getDeployConfiguration_TargetServer(), (Object)server);
        commandList.add(addServer);
        commandList.add(setTarget);
        return new CompoundCommand(CMD_LABEL_ADD_TARGET, CMD_DESC_ADD_TARGET, commandList);
    }
}

