/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.ui.actions;

import java.util.Random;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFileFactory;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.Dialog;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.ServerSelectionDialogPage;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class BasePackageActionDelegate implements IObjectActionDelegate {

	private IStructuredSelection mSelection = null;

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate2#runWithEvent(org.eclipse.jface.action.IAction,
	 *      org.eclipse.swt.widgets.Event)
	 */
	public void runWithEvent(IAction action, Event event) {
		run(action);
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(Event event) {
		run((IAction) null);
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		if (mSelection == null
				|| !(mSelection.getFirstElement() instanceof IPackage)) {
			return;
		}
		IPackage thePackage = (IPackage) mSelection.getFirstElement();
		Root root = DeployFileFactory.eINSTANCE.createRoot();
		DeployPackage deployPackage = DeployFileFactory.eINSTANCE
				.createDeployPackage(root, thePackage.getFile()
						.getProjectRelativePath().toString());
		DeployConfiguration deployConfig = DeployFileFactory.eINSTANCE
				.createDeployConfiguration(null, deployPackage);

		ServerSelectionDialogPage page = new ServerSelectionDialogPage();
		Dialog dialog = new Dialog(DeployCorePlugin.getDefault()
				.getWorkbench().getActiveWorkbenchWindow().getShell(), page);

		page.init(deployPackage, thePackage, null);
		if (dialog.open() == Dialog.OK) {
			ResourceSet rs = new ResourceSetImpl();
			Resource resource = rs
					.createResource(createDeployResourceURI(thePackage));
			DeployServer target = page.getSelectedDeployServer();

			resource.getContents().add(root);

			root.getServer().add(target);
			deployConfig.setTargetServer(target);

			BaseAction deployAction = getExecuteAction(DeployCorePlugin.getDefault()
							.getWorkbench().getActiveWorkbenchWindow()
							.getShell());
			deployAction.selectionChanged(new StructuredSelection(root));
			deployAction.run();
		}
	}

	protected abstract BaseAction getExecuteAction(Shell shell);
	
	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			mSelection = (IStructuredSelection) selection;
		}
	}

	private URI createDeployResourceURI(IPackage thePackage) {
		IPath pkgPath = thePackage.getFile().getFullPath();
		String pkgName = pkgPath.removeFileExtension().lastSegment();
		String deployName = pkgName + '_' + Math.abs(new Random().nextInt());
		IPath deployPath = pkgPath.removeLastSegments(1).append(deployName)
				.addFileExtension("deploy"); //$NON-NLS-1$
		return URI.createPlatformResourceURI(deployPath.toString());
	}
}
