/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.commands;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.PromptForConnectionAndEndCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.ElementTypeLabelProvider;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.MetamodelType;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;
import org.eclipse.swt.graphics.Image;

public class PromptForConnectionAndEndCommandEx
extends PromptForConnectionAndEndCommand {
    private static Image EXISTING = null;
    protected static String EXISTING_ELEMENT = DiagramUIMessages.ConnectionHandle_Popup_ExistingElement;
    private CreateConnectionRequest request;
    private IGraphicalEditPart _containerEP;

    public PromptForConnectionAndEndCommandEx(CreateConnectionRequest request, IGraphicalEditPart containerEP) {
        super(request, containerEP);
        this.request = request;
        this._containerEP = containerEP;
    }

    protected List getEndMenuContent(Object connectionItem) {
        List l = super.getEndMenuContent(connectionItem);
        if ((MetamodelType)connectionItem == BpmnElementTypes.Association_3003) {
            l.remove(EXISTING_ELEMENT);
            return l;
        }
        EditPart source = this.request.getSourceEditPart();
        EditPart target = this.request.getTargetEditPart();
        EditPart sPool = this.getPool(source);
        EditPart tPool = this.getPool(target);
        EditPart sContainer = this.getContainer(source.getParent());
        if (!(connectionItem instanceof MetamodelType)) {
            return l;
        }
        if ((MetamodelType)connectionItem == BpmnElementTypes.MessagingEdge_3002) {
            if (tPool != null && sPool.equals(tPool)) {
                l.clear();
            }
        } else if (!((MetamodelType)connectionItem != BpmnElementTypes.SequenceEdge_3001 || tPool == null || sContainer == this._containerEP && sPool.equals(tPool))) {
            l.clear();
        }
        return l;
    }

    protected EditPart getPool(EditPart editPart) {
        if (editPart instanceof PoolEditPart) {
            return editPart;
        }
        if (editPart == null) {
            return null;
        }
        EditPart parent = editPart.getParent();
        while (!(parent instanceof PoolEditPart) && parent != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    protected EditPart getContainer(EditPart editPart) {
        if (editPart instanceof PoolPoolCompartmentEditPart || editPart instanceof SubProcessSubProcessBodyCompartmentEditPart) {
            return editPart;
        }
        EditPart parent = editPart.getParent();
        if (parent == null) {
            return null;
        }
        return this.getContainer(parent);
    }

    protected ILabelProvider getConnectionAndEndLabelProvider(Object connectionItem) {
        return new ConnectionAndEndLabelProviderEx(connectionItem);
    }

    protected class ConnectionAndEndLabelProviderEx
    extends ElementTypeLabelProvider {
        private Object connectionItem;

        public void dispose() {
            super.dispose();
            if (EXISTING != null) {
                EXISTING.dispose();
                EXISTING = null;
            }
        }

        protected ConnectionAndEndLabelProviderEx(Object connectionItem) {
            this.connectionItem = connectionItem;
        }

        public Image getImage(Object object) {
            if (EXISTING_ELEMENT.equals(object)) {
                EXISTING = BpmnDiagramEditorPlugin.getBundledImageDescriptor("icons/obj24/existingElement.png").createImage();
                return EXISTING;
            }
            return super.getImage(object);
        }

        public String getText(Object element) {
            if (element instanceof String && EXISTING_ELEMENT.equals(element)) {
                return "Connect to an existing element";
            }
            String theInputStr = null;
            if (element instanceof IElementType) {
                theInputStr = PromptForConnectionAndEndCommandEx.this.isDirectionReversed() ? "Connect from a new {0}" : "Connect to a new {0}";
                String text = NLS.bind((String)theInputStr, (Object[])new Object[]{super.getText(element)});
                return text;
            }
            theInputStr = PromptForConnectionAndEndCommandEx.this.isDirectionReversed() ? "Connect from {0}" : "Connect to {0}";
            String text = NLS.bind((String)theInputStr, (Object[])new Object[]{super.getText(element)});
            return text;
        }

        protected Object getConnectionItem() {
            return this.connectionItem;
        }
    }
}

