/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBorderCompartmentEditPart;
import org.eclipse.stp.bpmn.policies.ResizableShapeEditPolicyEx;
import org.eclipse.stp.bpmn.tools.SubProcessResizeTracker;
import org.eclipse.stp.bpmn.tools.TaskDragEditPartsTrackerEx;

public class ResizableSubProcessEditPolicy
extends ResizableShapeEditPolicyEx {
    protected Handle createHandle(GraphicalEditPart owner, int direction) {
        return new SubProcessResizeHandle(owner, direction);
    }

    protected void replaceHandleDragEditPartsTracker(Handle handle) {
        if (handle instanceof AbstractHandle) {
            AbstractHandle h = (AbstractHandle)handle;
            h.setDragTracker((DragTracker)new TaskDragEditPartsTrackerEx(this.getHost()));
        }
    }

    protected Command getAutoSizeCommand(Request request) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Dimension size = SubProcessEditPart.EXPANDED_SIZE.getCopy();
        Dimension minSize = this.getSubProcessMinSize((GraphicalEditPart)this.getHost());
        size.width = Math.max(size.width, minSize.width);
        size.height = Math.max(size.height, minSize.height);
        SetBoundsCommand resizeCommand = new SetBoundsCommand(editingDomain, DiagramUIMessages.SetAutoSizeCommand_Label, (IAdaptable)new EObjectAdapter((EObject)((View)this.getHost().getModel())), size);
        return new ICommandProxy((ICommand)resizeCommand);
    }

    public Dimension getSubProcessMinSize(GraphicalEditPart subprocessEditPart) {
        SubProcessSubProcessBodyCompartmentEditPart body = null;
        SubProcessSubProcessBorderCompartmentEditPart border = null;
        for (Object child : subprocessEditPart.getChildren()) {
            if (child instanceof SubProcessSubProcessBodyCompartmentEditPart) {
                body = (SubProcessSubProcessBodyCompartmentEditPart)((Object)child);
            }
            if (!(child instanceof SubProcessSubProcessBorderCompartmentEditPart)) continue;
            border = (SubProcessSubProcessBorderCompartmentEditPart)((Object)child);
        }
        if (body == null) {
            return new Dimension(0, 0);
        }
        Dimension maxRoomOfChildren = new Dimension(0, 0);
        for (Object ep : body.getChildren()) {
            if (!(ep instanceof IGraphicalEditPart)) continue;
            IFigure figure = ((IGraphicalEditPart)ep).getFigure();
            Rectangle bounds = figure.getBounds();
            maxRoomOfChildren.height = Math.max(bounds.y + bounds.height, maxRoomOfChildren.height);
            maxRoomOfChildren.width = Math.max(bounds.x + bounds.width, maxRoomOfChildren.width);
        }
        maxRoomOfChildren.expand(SubProcessEditPart.INSETS.getWidth(), SubProcessEditPart.INSETS.getHeight() + 2);
        maxRoomOfChildren.height += border.getFigure().getBounds().height;
        return maxRoomOfChildren;
    }

    protected static class SubProcessResizeHandle
    extends ResizableShapeEditPolicyEx.ResizeHandleEx {
        public SubProcessResizeHandle(GraphicalEditPart owner, int direction) {
            super(owner, direction);
        }

        protected DragTracker createDragTracker() {
            return new SubProcessResizeTracker(this.getOwner(), this.cursorDirection);
        }
    }
}

