/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.infrastructure.emf;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.infrastructure.emfworkbench.EMFWorkbenchEditResourceHandler;

public class AdapterFactoryDescriptor
implements Comparable {
    private String packageURI = null;
    private String id = null;
    private Set viewIDs = null;
    private final int loadOrder;
    private IConfigurationElement element;
    private static int loadOrderCounter = 0;

    public AdapterFactoryDescriptor(IConfigurationElement anElement) {
        this.element = anElement;
        this.packageURI = this.element.getAttribute("packageURI");
        this.id = this.element.getAttribute("id");
        Assert.isNotNull(this.packageURI, EMFWorkbenchEditResourceHandler.getString("AdapterFactoryDescriptor_ERROR_0"));
        Assert.isNotNull(this.id, EMFWorkbenchEditResourceHandler.getString("AdapterFactoryDescriptor_ERROR_1", new Object[]{this.element.getDeclaringExtension().getExtensionPointUniqueIdentifier()}));
        this.readViewIDs();
        this.loadOrder = loadOrderCounter++;
    }

    protected IConfigurationElement getElement() {
        return this.element;
    }

    public String getPluginId() {
        IExtension extension;
        String pluginId = null;
        if (this.element != null && (extension = this.element.getDeclaringExtension()) != null) {
            pluginId = extension.getNamespace();
        }
        return pluginId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AdapterFactoryDescriptor");
        sb.append('[');
        sb.append(this.packageURI);
        sb.append(",p");
        if (this.viewIDs != null && !this.viewIDs.isEmpty()) {
            sb.append(':');
            boolean first = true;
            Iterator iter = this.viewIDs.iterator();
            while (iter.hasNext()) {
                if (!first) {
                    sb.append(',');
                }
                first = false;
                sb.append(iter.next());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    private void readViewIDs() {
        this.viewIDs = new HashSet(3);
        IConfigurationElement[] children = this.element.getChildren("view");
        if (children == null || children.length == 0) {
            return;
        }
        String viewID = null;
        int i = 0;
        while (i < children.length) {
            viewID = children[i].getAttribute("id");
            if (viewID != null) {
                this.viewIDs.add(viewID);
            }
            ++i;
        }
    }

    public AdapterFactory createInstance() {
        if (this.element == null) {
            return null;
        }
        AdapterFactory factory = null;
        try {
            factory = (AdapterFactory)this.element.createExecutableExtension("className");
        }
        catch (CoreException e) {
            JEMUtilPlugin.getLogger().logError((Throwable)e);
            factory = null;
        }
        return factory;
    }

    public String getPackageURI() {
        return this.packageURI;
    }

    public Set getViewIDs() {
        return this.viewIDs;
    }

    public boolean appliesTo(String viewID) {
        return this.viewIDs.isEmpty() || this.viewIDs.contains(viewID);
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (!(o instanceof AdapterFactoryDescriptor)) {
            return 1;
        }
        AdapterFactoryDescriptor desc = (AdapterFactoryDescriptor)o;
        int pCompare = this.getPriority() - desc.getPriority();
        if (pCompare != 0) {
            return -pCompare;
        }
        if (this.viewIDs != null && !this.viewIDs.isEmpty()) {
            return -1;
        }
        return 1;
    }

    public int getPriority() {
        return -1;
    }

    public String getID() {
        return this.id;
    }

    public int getLoadOrder() {
        return this.loadOrder;
    }
}

