/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.infrastructure.emf;

import org.eclipse.core.resources.IProject;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModel;
import org.eclipse.stp.core.infrastructure.emf.IEditModelFactory;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.internal.infrastructure.emfworkbench.EMFWorkbenchContext;

public class EditModelFactory
implements IEditModelFactory {
    private static EditModelFactory eInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IEditModelFactory init() {
        Class<EditModelFactory> clazz = EditModelFactory.class;
        synchronized (EditModelFactory.class) {
            if (eInstance == null) {
                eInstance = new EditModelFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return eInstance;
        }
    }

    public IEditModel getEditModel(IProject aProject, String editModelID) {
        EMFWorkbenchContext context = EMFWorkbenchContext.getInstance(aProject);
        return context.getEditModel(editModelID);
    }

    public IEditModelScribbler createScribbler(IProject aProject, String editModelID, IScribblerDomain[] domains, boolean toMakeReadonly) throws EditModelException {
        IEditModel editModel = this.getEditModel(aProject, editModelID);
        return editModel.createScribbler(domains, toMakeReadonly);
    }

    public IEditModelScribbler createScribblerForRead(IProject aProject, IScribblerDomain domain) throws EditModelException {
        IEditModel editModel = this.getEditModel(aProject, domain.getEditModelLabel());
        return editModel.createScribbler(new IScribblerDomain[]{domain}, true);
    }

    public IEditModelScribbler createScribblerForWrite(IProject aProject, IScribblerDomain domain) throws EditModelException {
        IEditModel editModel = this.getEditModel(aProject, domain.getEditModelLabel());
        return editModel.createScribbler(new IScribblerDomain[]{domain}, false);
    }

    public IEditModelScribbler createScribblerForRead(IProject aProject, String editModelID, IScribblerDomain[] domains) throws EditModelException {
        IEditModel editModel = this.getEditModel(aProject, editModelID);
        return editModel.createScribbler(domains, true);
    }

    public IEditModelScribbler createScribblerForWrite(IProject aProject, String editModelID, IScribblerDomain[] domains) throws EditModelException {
        IEditModel editModel = this.getEditModel(aProject, editModelID);
        return editModel.createScribbler(domains, false);
    }
}

