/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.infrastructure.emfworkbench;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jem.util.emf.workbench.ResourceHandler;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;

public class WorkspaceResourceHandler
implements ResourceHandler {
    public Resource getResource(ResourceSet originatingResourceSet, URI uri) {
        if (WorkbenchResourceHelperBase.isPlatformResourceURI((URI)uri)) {
            return this.getResourceForPlatformProtocol(originatingResourceSet, uri);
        }
        URI mappedURI = ((URIConverterImpl.URIMap)originatingResourceSet.getURIConverter().getURIMap()).getURI(uri);
        if (this.isGlobalPluginLoad(mappedURI)) {
            return this.getResourceForPlatformPluginProtocol(originatingResourceSet, uri);
        }
        return null;
    }

    protected Resource createResourceForPlatformProtocol(ResourceSet originatingResourceSet, URI uri) {
        ResourceSet set;
        String projectName = uri.segment(1);
        IProject project = this.getProject(projectName);
        if (project != null && project.isAccessible() && originatingResourceSet != (set = WorkbenchResourceHelperBase.getResourceSet((IProject)project))) {
            return this.createResource(uri, set);
        }
        return null;
    }

    protected Resource createResourceForPlatformPluginProtocol(ResourceSet originatingResourceSet, URI uri) {
        ResourceSet set = JEMUtilPlugin.getPluginResourceSet();
        return this.createResource(uri, set);
    }

    protected Resource createResource(URI uri, ResourceSet redirectedResourceSet) {
        return redirectedResourceSet.createResource(uri);
    }

    protected Resource getResourceForPlatformProtocol(ResourceSet originatingResourceSet, URI uri) {
        ResourceSet set;
        String projectName = uri.segment(1);
        IProject project = this.getProject(projectName);
        if (project != null && project.isAccessible() && originatingResourceSet != (set = WorkbenchResourceHelperBase.getResourceSet((IProject)project))) {
            return this.getResource(uri, set);
        }
        return null;
    }

    protected Resource getResourceForPlatformPluginProtocol(ResourceSet originatingResourceSet, URI uri) {
        ResourceSet set = JEMUtilPlugin.getPluginResourceSet();
        return this.getResource(uri, set);
    }

    protected Resource getResource(URI uri, ResourceSet redirectedResourceSet) {
        return redirectedResourceSet.getResource(uri, false);
    }

    protected IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected IProject getProject(String projectName) {
        IWorkspace ws = this.getWorkspace();
        if (ws == null) {
            return null;
        }
        return ws.getRoot().getProject(projectName);
    }

    protected IProject getProject(ResourceSet resourceSet) {
        return WorkbenchResourceHelperBase.getProject((ResourceSet)resourceSet);
    }

    public Resource createResource(ResourceSet originatingResourceSet, URI uri) {
        if (WorkbenchResourceHelperBase.isPlatformResourceURI((URI)uri)) {
            return this.createResourceForPlatformProtocol(originatingResourceSet, uri);
        }
        URI mappedURI = ((URIConverterImpl.URIMap)originatingResourceSet.getURIConverter().getURIMap()).getURI(uri);
        if (this.isGlobalPluginLoad(mappedURI)) {
            return this.createResourceForPlatformPluginProtocol(originatingResourceSet, uri);
        }
        return null;
    }

    public EObject getEObjectFailed(ResourceSet originatingResourceSet, URI uri, boolean loadOnDemand) {
        return null;
    }

    protected boolean isGlobalPluginLoad(URI aURI) {
        if (WorkbenchResourceHelperBase.isPlatformPluginResourceURI((URI)aURI)) {
            String[] globalPlugins = JEMUtilPlugin.getGlobalLoadingPluginNames();
            int i = 0;
            while (i < globalPlugins.length) {
                if (aURI.segment(1).startsWith(globalPlugins[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

