/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.tests;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.utils.TestUtilities;

public abstract class ScProjectBaseTest
extends TestCase {
    protected static final String JAVA_FILE_NAME = "GreeterRPCLit.java";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ScProjectBaseTest.class);
    protected IProject project;
    protected IFile[] files;

    protected abstract String getProjectName();

    protected abstract String[] getProjectFiles();

    protected abstract String[] getResourceFiles();

    protected void setUp() throws Exception {
        try {
            this.project = TestUtilities.createTestCeltixProject((String)this.getProjectName());
            TestUtilities.setupJavaProject(this.project);
            this.setupTestFiles();
        }
        catch (Exception th) {
            LOG.error((Object)"", (Throwable)th);
            throw th;
        }
    }

    private void setupTestFiles() throws Exception {
        String[] projectFiles = this.getProjectFiles();
        String[] resourceFiles = this.getResourceFiles();
        this.files = new IFile[projectFiles.length];
        int i = 0;
        while (i < projectFiles.length) {
            IFile f = this.project.getFile(projectFiles[i]);
            if (!f.exists()) {
                TestUtilities.checkFolder((IProject)this.project, (String)projectFiles[i]);
                this.project.refreshLocal(0, null);
                TestUtilities.addFileResourceToTestProject((IProject)this.project, (String)projectFiles[i], ((Object)((Object)this)).getClass(), (String)resourceFiles[i]);
            }
            this.files[i] = f;
            ++i;
        }
    }

    protected void tearDown() throws Exception {
        try {
            this.project.delete(true, null);
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }
}

