/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod;

import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.utils.TestUtilities;
import org.eclipse.stp.sc.jaxws.wizards.ScWizardDialog;
import org.eclipse.stp.sc.jaxws.wizards.annotations.AnnotationAttributePage;
import org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod.CreateWebMethodWizard;
import org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod.MethodSelectionPage2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateWebMethodWizardTest
extends TestCase {
    private static final String TEST_PROJECT_NAME = "CreateWebMethodWizardTestProject";
    private static final String LOCAL_JAVA = "MyWebService.java";
    private static final String JAVA_RESOURCE = "MyWebService.java_resource";
    private static final String RESULT_METHOD = "sayHi";
    private static final String ONEWAY_METHOD = "sendData";
    IProject testProject;
    IJavaElement javaFile;
    IMember typeMember;
    IMember methodMember;
    CreateWebMethodWizard wizard;
    WizardDialog dialog;
    MethodSelectionPage2 selectionPage;
    AnnotationAttributePage methodAttributePage;
    AnnotationAttributePage resultAttributePage;
    AnnotationAttributePage onewayAttributePage;
    AnnotationAttributePage requestWrapperAttributePage;
    AnnotationAttributePage responseWrapperAttributePage;
    private IPreferenceStore preference_store;
    private String originalPrefFlag;

    protected void setUp() throws Exception {
        this.preference_store = ScJaxWsPlugin.getDefault().getPreferenceStore();
        this.originalPrefFlag = this.preference_store.getString("annWizEnabled");
        this.preference_store.setValue("annWizEnabled", "enabled");
        this.testProject = TestUtilities.createTestCeltixProject((String)TEST_PROJECT_NAME);
        IFile testFile = TestUtilities.addFileResourceToTestProject((IProject)this.testProject, (String)LOCAL_JAVA, ((Object)((Object)this)).getClass(), (String)"/resources/MyWebService.java_resource");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        TestUtilities.openEditor((IWorkbenchWindow)window, (IFile)testFile);
        this.javaFile = JavaCore.create((IFile)testFile);
        CreateWebMethodWizardTest.assertTrue((boolean)(this.javaFile instanceof ICompilationUnit));
        IType[] types = ((ICompilationUnit)this.javaFile).getTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i] instanceof IMember) {
                this.typeMember = types[i];
                this.methodMember = types[i].getMethod("bye", new String[0]);
                break;
            }
            ++i;
        }
        this.openMethodWizard(this.typeMember);
        this.setupPages();
    }

    protected void tearDown() throws Exception {
        this.preference_store.setValue("annWizEnabled", this.originalPrefFlag);
        this.closeMethodWizard();
        if (this.testProject != null && this.testProject.exists()) {
            this.testProject.delete(true, null);
        }
    }

    private void openMethodWizard(IMember member) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.wizard = new CreateWebMethodWizard(member);
        this.dialog = new ScWizardDialog(window.getShell(), (IWizard)this.wizard);
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
    }

    protected void closeMethodWizard() throws Exception {
        this.dialog.close();
        this.selectionPage = null;
        this.methodAttributePage = null;
        this.resultAttributePage = null;
        this.onewayAttributePage = null;
        this.requestWrapperAttributePage = null;
        this.responseWrapperAttributePage = null;
        this.wizard = null;
    }

    protected void setupPages() throws Exception {
        this.selectionPage = (MethodSelectionPage2)this.wizard.getPage("selectionPage");
        String name = AnnotationAttributePage.generatePageName(WebMethod.class);
        this.methodAttributePage = (AnnotationAttributePage)this.wizard.getPage(name);
        name = AnnotationAttributePage.generatePageName(WebResult.class);
        this.resultAttributePage = (AnnotationAttributePage)this.wizard.getPage(name);
        name = AnnotationAttributePage.generatePageName(Oneway.class);
        this.onewayAttributePage = (AnnotationAttributePage)this.wizard.getPage(name);
        name = AnnotationAttributePage.generatePageName(RequestWrapper.class);
        this.requestWrapperAttributePage = (AnnotationAttributePage)this.wizard.getPage(name);
        name = AnnotationAttributePage.generatePageName(ResponseWrapper.class);
        this.responseWrapperAttributePage = (AnnotationAttributePage)this.wizard.getPage(name);
    }

    public void testWizardNotNull() {
        CreateWebMethodWizardTest.assertNotNull((Object)this.wizard);
    }

    public void testNumberWizardPages() throws Exception {
        this.preference_store.setValue("annWizEnabled", "disabled");
        this.closeMethodWizard();
        this.openMethodWizard(this.typeMember);
        CreateWebMethodWizardTest.assertEquals((int)1, (int)this.wizard.getPageCount());
        this.preference_store.setValue("annWizEnabled", "enabled");
        this.closeMethodWizard();
        this.openMethodWizard(this.typeMember);
        CreateWebMethodWizardTest.assertEquals((int)6, (int)this.wizard.getPageCount());
        this.preference_store.setValue("annWizEnabled", "disabled");
        this.closeMethodWizard();
        this.openMethodWizard(this.methodMember);
        CreateWebMethodWizardTest.assertEquals((int)0, (int)this.wizard.getPageCount());
        this.preference_store.setValue("annWizEnabled", "enabled");
        this.closeMethodWizard();
        this.openMethodWizard(this.methodMember);
        CreateWebMethodWizardTest.assertEquals((int)2, (int)this.wizard.getPageCount());
    }

    public void testContextHelpID() {
    }

    public void testSelectionPageIsStartingPage() {
        CreateWebMethodWizardTest.assertEquals((Object)this.selectionPage, (Object)this.wizard.getStartingPage());
    }

    public void testNoPreviousPageInitially() {
        CreateWebMethodWizardTest.assertNull((Object)this.wizard.getPreviousPage((IWizardPage)this.selectionPage));
    }

    public void testHasNextPageInitially() {
        CreateWebMethodWizardTest.assertNotNull((Object)this.wizard.getNextPage((IWizardPage)this.selectionPage));
    }

    public void testSelectionPageNextPageAttributePropertyPage() {
        CreateWebMethodWizardTest.assertEquals((String)"wizard.getNextPage() wrong", (Object)this.methodAttributePage, (Object)this.wizard.getNextPage((IWizardPage)this.selectionPage));
        CreateWebMethodWizardTest.assertEquals((String)"page.getNextPage() wrong", (Object)this.methodAttributePage, (Object)this.selectionPage.getNextPage());
    }

    public void testAttributePagePreviousPageIsSelectionPage() {
        CreateWebMethodWizardTest.assertEquals((String)"wizard.getPreviousPage() wrong", (Object)this.selectionPage, (Object)this.wizard.getPreviousPage((IWizardPage)this.methodAttributePage));
        CreateWebMethodWizardTest.assertEquals((String)"page.getPreviousPage() wrong", (Object)this.selectionPage, (Object)this.methodAttributePage.getPreviousPage());
    }

    public void testResultMethodSelected() throws Exception {
        this.closeMethodWizard();
        IJavaElement[] children = ((ICompilationUnit)this.javaFile).findPrimaryType().getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IMethod && ((IMethod)children[i]).getElementName().equals(RESULT_METHOD)) {
                this.typeMember = (IMember)children[i];
                break;
            }
            ++i;
        }
        CreateWebMethodWizardTest.assertNotNull((Object)this.typeMember);
        this.openMethodWizard(this.typeMember);
        this.setupPages();
        CreateWebMethodWizardTest.assertNotNull((Object)this.resultAttributePage);
        CreateWebMethodWizardTest.assertNotNull((Object)this.responseWrapperAttributePage);
        CreateWebMethodWizardTest.assertNotNull((Object)this.requestWrapperAttributePage);
        CreateWebMethodWizardTest.assertNull((Object)this.onewayAttributePage);
        CreateWebMethodWizardTest.assertEquals((Object)this.methodAttributePage, (Object)this.wizard.getStartingPage());
        CreateWebMethodWizardTest.assertEquals((Object)this.requestWrapperAttributePage, (Object)this.methodAttributePage.getNextPage());
        CreateWebMethodWizardTest.assertEquals((Object)this.resultAttributePage, (Object)this.requestWrapperAttributePage.getNextPage());
    }

    public void testOnewayMethodSelected() throws Exception {
        this.closeMethodWizard();
        IJavaElement[] children = ((ICompilationUnit)this.javaFile).findPrimaryType().getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IMethod && ((IMethod)children[i]).getElementName().equals(ONEWAY_METHOD)) {
                this.typeMember = (IMember)children[i];
                break;
            }
            ++i;
        }
        CreateWebMethodWizardTest.assertNotNull((Object)this.typeMember);
        this.openMethodWizard(this.typeMember);
        this.setupPages();
        CreateWebMethodWizardTest.assertNull((Object)this.resultAttributePage);
        CreateWebMethodWizardTest.assertNull((Object)this.responseWrapperAttributePage);
        CreateWebMethodWizardTest.assertNotNull((Object)this.onewayAttributePage);
        CreateWebMethodWizardTest.assertNotNull((Object)this.requestWrapperAttributePage);
        CreateWebMethodWizardTest.assertEquals((Object)this.methodAttributePage, (Object)this.wizard.getStartingPage());
        CreateWebMethodWizardTest.assertEquals((Object)this.requestWrapperAttributePage, (Object)this.methodAttributePage.getNextPage());
        CreateWebMethodWizardTest.assertEquals((Object)this.onewayAttributePage, (Object)this.requestWrapperAttributePage.getNextPage());
    }
}

