/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.runtimeintegrator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.runtimeintegrator.IGeneratorTool;
import org.eclipse.stp.sc.common.runtimeintegrator.IParameterPage;
import org.eclipse.stp.sc.common.runtimeintegrator.RtIntegratorMgr;
import org.eclipse.stp.sc.jaxws.preferences.PreferencesAccessor;
import org.eclipse.stp.sc.jaxws.runtimeintegrator.IRuntimeKitProcessor;
import org.eclipse.stp.sc.jaxws.runtimeintegrator.RuntimeKitProcessor;

public class JaxWSRtIntegratorMgr
extends RtIntegratorMgr {
    public static final String EXT_JAXWS_SERVERTYPE = "jaxws.runtime";
    public static final String EXT_TOOLTYPE_WSDL2JAVA = "org.eclipse.stp.sc.jaxws.wsdl2java";
    public static final String EXT_TOOLTYPE_JAVA2WSDL = "org.eclipse.stp.sc.jaxws.java2wsdl";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JaxWSRtIntegratorMgr.class);
    private static JaxWSRtIntegratorMgr instance;

    private JaxWSRtIntegratorMgr() {
    }

    public static JaxWSRtIntegratorMgr getInstance() {
        if (instance == null) {
            instance = new JaxWSRtIntegratorMgr();
        }
        return instance;
    }

    public IGeneratorTool getWsdltoJavaGenerator(IProject project) throws CoreException {
        String runtimeID = this.getRuntimeIntegratorID(project);
        return this.getGeneratorTool(runtimeID, EXT_TOOLTYPE_WSDL2JAVA);
    }

    public IGeneratorTool getJavaToWsdlGenerator(IProject project) throws CoreException {
        String runtimeID = this.getRuntimeIntegratorID(project);
        return this.getGeneratorTool(runtimeID, EXT_TOOLTYPE_JAVA2WSDL);
    }

    public IRuntimeKitProcessor getRuntimeKitProcessor(IProject project) throws CoreException {
        String runtimeID = this.getRuntimeIntegratorID(project);
        return this.getRuntimeKitProcessor(runtimeID);
    }

    public RuntimeKitProcessor getRuntimeKitProcessor(String providerExtUID) throws CoreException {
        return new RuntimeKitProcessor(this.getKitProcessorTemplate(providerExtUID), this.getKitRootFolder(providerExtUID));
    }

    public String getDefaultRuntimeIntegratorID() {
        String id = "org.eclipse.stp.sc.cxf.runtimeintegrator";
        LOG.debug((Object)("defualt runtime integrator for JAXWS:" + id));
        return id;
    }

    private IPath getKitRootFolder(String providerExtUID) {
        String kitPath = PreferencesAccessor.getKitInstallLocation(providerExtUID);
        if (kitPath == null || kitPath.equals("")) {
            kitPath = System.getProperty("jaxws_kit_location");
        }
        return new Path(kitPath);
    }

    public IParameterPage getParameterPage(String runtimeId) throws CoreException {
        return this.getParameterPage(runtimeId, EXT_TOOLTYPE_WSDL2JAVA);
    }

    public IParameterPage getParameterPage(IProject project) throws CoreException {
        return this.getParameterPage(project, EXT_TOOLTYPE_WSDL2JAVA);
    }
}

