/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.runtimeprovider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.preferences.PreferencesAccessor;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IJavaToWsdlGenerator;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IParameterPage;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPostProjectProcessor;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IProjectDirTemplate;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IRuntimeKitProcessor;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IRuntimeKitProcessorTemplate;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IRuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWsdlToJavaGenerator;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWsdlToJavaWizard;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeKitProcessor;
import org.eclipse.stp.sc.jaxws.workspace.ScNature;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class RuntimeProviderManager
implements IRuntimeProviderManager {
    private static final String EXT_POINT_SC_RUNTIME_PROVIDER = "org.eclipse.stp.sc.jaxws.runtimeProvider";
    private static final String EXT_ELT_SC_KIT_PROCESSOR = "KitProcessor";
    private static final String EXT_ATT_SC_PROCESSOR_CLASS = "kit_processor_class";
    private static final String EXT_ELT_SC_W2J_GEN = "wsdltoJavaGenerator";
    private static final String EXT_ATT_SC_W2J_GEN_CLASS = "class";
    private static final String EXT_ATT_SC_W2J_PARAM_PAGE = "parameter_page";
    private static final String EXT_ELT_SC_J2W_GEN = "javaToWsdlGenerator";
    private static final String EXT_ATT_SC_J2W_GEN_CLASS = "class";
    private static final String EXT_ELT_SC_W2J_WIZ = "wsdlToJavaWizard";
    private static final String EXT_ATT_SC_W2J_WIZ_CLASS = "class";
    private static final String EXT_ELT_SC_DIR_TEMP = "projectDirTemplate";
    private static final String EXT_ATT_SC_DIR_TEMP_CLASS = "class";
    private static final String EXT_ATT_SC_POST_PROCESSOR_CLASS = "postProjectProcessor";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(RuntimeProviderManager.class);
    private static RuntimeProviderManager instance;
    private static Map<IProject, IProjectDirTemplate> prjDirTempMap;
    private static Map<IProject, IPostProjectProcessor> prjPostProcessorMap;

    private RuntimeProviderManager() {
    }

    public static RuntimeProviderManager getInstance() {
        if (instance == null) {
            instance = new RuntimeProviderManager();
        }
        if (prjDirTempMap == null) {
            prjDirTempMap = new HashMap<IProject, IProjectDirTemplate>();
        }
        if (prjPostProcessorMap == null) {
            prjPostProcessorMap = new HashMap<IProject, IPostProjectProcessor>();
        }
        return instance;
    }

    public IWsdlToJavaGenerator getWsdltoJavaGenerator(IProject aProject) {
        return this.getWsdltoJavaGenerator(this.getRuntimeProviderUID(aProject));
    }

    public IWsdlToJavaWizard getWsdlToJavaWizard(IProject aProject) {
        return this.getWsdltoJavaWizard(this.getRuntimeProviderUID(aProject));
    }

    public IJavaToWsdlGenerator getJavaToWsdlGenerator(IProject aProject) {
        return this.getJavaToWsdlGenerator(this.getRuntimeProviderUID(aProject));
    }

    public IRuntimeKitProcessor getRuntimeKitProcessor(IProject aProject) {
        String providerExtUID = this.getRuntimeProviderUID(aProject);
        return this.getRuntimeKitProcessor(providerExtUID);
    }

    public RuntimeKitProcessor getRuntimeKitProcessor(String providerExtUID) {
        if (this.getExtension(providerExtUID) == null) {
            return null;
        }
        return new RuntimeKitProcessor(this.getRuntimeKitTemplateProcessor(providerExtUID), this.getKitRootFolder(providerExtUID));
    }

    public IProjectDirTemplate getProjectDirTemplate(IProject aProject) {
        if (prjDirTempMap.keySet().contains(aProject)) {
            return prjDirTempMap.get(aProject);
        }
        IProjectDirTemplate template = this.getProjectDirTemplate(this.getRuntimeProviderUID(aProject));
        prjDirTempMap.put(aProject, template);
        return template;
    }

    public IPostProjectProcessor getPostProjectProcessor(IProject aProject) {
        if (prjPostProcessorMap.keySet().contains(aProject)) {
            return prjPostProcessorMap.get(aProject);
        }
        IPostProjectProcessor processor = this.getPostProjectProcessor(this.getRuntimeProviderUID(aProject));
        prjPostProcessorMap.put(aProject, processor);
        return processor;
    }

    private String getRuntimeProviderUID(IProject aProject) {
        try {
            if (ScNature.hasNature(aProject)) {
                ScNature theNature = new ScNature();
                theNature.setProject(aProject);
                String providerUID = theNature.getRuntimeProviderUID();
                if (providerUID == null) {
                    String pickedProviderId = this.pickAProvider();
                    theNature.setRuntimeProviderId(pickedProviderId);
                    return pickedProviderId;
                }
                return providerUID;
            }
            String providerUID = this.pickAProvider();
            LOG.debug((Object)("return provider id without ScNature:" + providerUID));
            return providerUID;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public String pickAProvider() {
        IExtension[] allRegistredProviders = this.getAllRegistredProviders();
        int numberOfRegistredProviders = allRegistredProviders.length;
        return numberOfRegistredProviders < 1 ? null : (numberOfRegistredProviders == 1 ? allRegistredProviders[0].getUniqueIdentifier() : this.promptUserToPickAProvider(allRegistredProviders));
    }

    private String promptUserToPickAProvider(IExtension[] allRegistredProviders) {
        ListDialog dialog = new ListDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setTitle(ScJaxWsResources.getString("RuntimeProvider.dialog.title"));
        dialog.setMessage(ScJaxWsResources.getString("RuntimeProvider.dialog.message"));
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IExtension) {
                    return ((IExtension)element).getLabel();
                }
                return null;
            }
        });
        dialog.setBlockOnOpen(true);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result.length > 0) {
            ((IExtension)result[0]).getUniqueIdentifier();
        }
        return null;
    }

    public IExtension getExtension(String ID) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        return reg.getExtension(EXT_POINT_SC_RUNTIME_PROVIDER, ID);
    }

    public IExtension[] getAllRegistredProviders() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        return reg.getExtensionPoint(EXT_POINT_SC_RUNTIME_PROVIDER).getExtensions();
    }

    private IWsdlToJavaGenerator getWsdltoJavaGenerator(String ID) {
        if (this.getExtension(ID) == null) {
            return null;
        }
        IConfigurationElement[] extElts = this.getExtension(ID).getConfigurationElements();
        int extIndex = 0;
        while (extIndex < extElts.length) {
            IConfigurationElement cfgElt = extElts[extIndex];
            if (cfgElt.getName().equals(EXT_ELT_SC_W2J_GEN)) {
                try {
                    Object kitProcessorObj = cfgElt.createExecutableExtension("class");
                    if (kitProcessorObj instanceof IWsdlToJavaGenerator) {
                        return (IWsdlToJavaGenerator)kitProcessorObj;
                    }
                    LOG.error((Object)this.getLogErrMsgWrongClassType(ID, EXT_ATT_SC_PROCESSOR_CLASS, IWsdlToJavaGenerator.class));
                }
                catch (CoreException e) {
                    LOG.error((Object)this.getLogErrMsgNotCLass(ID, EXT_ATT_SC_PROCESSOR_CLASS), (Throwable)e);
                }
                return null;
            }
            ++extIndex;
        }
        return null;
    }

    public IProjectDirTemplate getProjectDirTemplate(String providerExtUID) {
        if (this.getExtension(providerExtUID) == null) {
            return null;
        }
        IConfigurationElement[] extElts = this.getExtension(providerExtUID).getConfigurationElements();
        int extIndex = 0;
        while (extIndex < extElts.length) {
            IConfigurationElement cfgElt = extElts[extIndex];
            if (cfgElt.getName().equals(EXT_ELT_SC_DIR_TEMP)) {
                try {
                    Object kitProcessorObj = cfgElt.createExecutableExtension("class");
                    if (kitProcessorObj instanceof IProjectDirTemplate) {
                        return (IProjectDirTemplate)kitProcessorObj;
                    }
                    LOG.error((Object)this.getLogErrMsgWrongClassType(providerExtUID, "class", IProjectDirTemplate.class));
                }
                catch (CoreException e) {
                    LOG.error((Object)this.getLogErrMsgNotCLass(providerExtUID, "class"), (Throwable)e);
                }
                return null;
            }
            ++extIndex;
        }
        return null;
    }

    public IPostProjectProcessor getPostProjectProcessor(String providerExtUID) {
        IConfigurationElement[] extElts = this.getExtension(providerExtUID).getConfigurationElements();
        int extIndex = 0;
        while (extIndex < extElts.length) {
            IConfigurationElement cfgElt = extElts[extIndex];
            if (cfgElt.getName().equals(EXT_ELT_SC_DIR_TEMP)) {
                block6: {
                    String obj = cfgElt.getAttribute(EXT_ATT_SC_POST_PROCESSOR_CLASS);
                    if (obj != null) break block6;
                    return null;
                }
                try {
                    Object prjProcessor = cfgElt.createExecutableExtension(EXT_ATT_SC_POST_PROCESSOR_CLASS);
                    if (prjProcessor instanceof IPostProjectProcessor) {
                        return (IPostProjectProcessor)prjProcessor;
                    }
                    LOG.error((Object)this.getLogErrMsgWrongClassType(providerExtUID, EXT_ATT_SC_POST_PROCESSOR_CLASS, IPostProjectProcessor.class));
                }
                catch (CoreException e) {
                    LOG.error((Object)this.getLogErrMsgNotCLass(providerExtUID, EXT_ATT_SC_POST_PROCESSOR_CLASS), (Throwable)e);
                }
                return null;
            }
            ++extIndex;
        }
        return null;
    }

    private IWsdlToJavaWizard getWsdltoJavaWizard(String ID) {
        if (this.getExtension(ID) == null) {
            return null;
        }
        IConfigurationElement[] extElts = this.getExtension(ID).getConfigurationElements();
        int extIndex = 0;
        while (extIndex < extElts.length) {
            IConfigurationElement cfgElt = extElts[extIndex];
            if (cfgElt.getName().equals(EXT_ELT_SC_W2J_WIZ)) {
                try {
                    Object kitProcessorObj = cfgElt.createExecutableExtension("class");
                    if (kitProcessorObj instanceof IWsdlToJavaWizard) {
                        return (IWsdlToJavaWizard)kitProcessorObj;
                    }
                    LOG.error((Object)this.getLogErrMsgWrongClassType(ID, EXT_ATT_SC_PROCESSOR_CLASS, IWsdlToJavaWizard.class));
                }
                catch (CoreException e) {
                    LOG.error((Object)this.getLogErrMsgNotCLass(ID, EXT_ATT_SC_PROCESSOR_CLASS), (Throwable)e);
                }
                return null;
            }
            ++extIndex;
        }
        return null;
    }

    private IJavaToWsdlGenerator getJavaToWsdlGenerator(String ID) {
        if (this.getExtension(ID) == null) {
            return null;
        }
        IConfigurationElement[] extElts = this.getExtension(ID).getConfigurationElements();
        int extIndex = 0;
        while (extIndex < extElts.length) {
            IConfigurationElement cfgElt = extElts[extIndex];
            if (cfgElt.getName().equals(EXT_ELT_SC_J2W_GEN)) {
                try {
                    Object kitProcessorObj = cfgElt.createExecutableExtension("class");
                    if (kitProcessorObj instanceof IJavaToWsdlGenerator) {
                        return (IJavaToWsdlGenerator)kitProcessorObj;
                    }
                    LOG.error((Object)this.getLogErrMsgWrongClassType(ID, EXT_ATT_SC_PROCESSOR_CLASS, IJavaToWsdlGenerator.class));
                }
                catch (CoreException e) {
                    LOG.error((Object)this.getLogErrMsgNotCLass(ID, EXT_ATT_SC_PROCESSOR_CLASS), (Throwable)e);
                }
                return null;
            }
            ++extIndex;
        }
        return null;
    }

    public IRuntimeKitProcessorTemplate getRuntimeKitTemplateProcessor(String uniqueIdentifier) {
        if (this.getExtension(uniqueIdentifier) == null) {
            return null;
        }
        IConfigurationElement[] extElts = this.getExtension(uniqueIdentifier).getConfigurationElements();
        int extIndex = 0;
        while (extIndex < extElts.length) {
            IConfigurationElement cfgElt = extElts[extIndex];
            if (cfgElt.getName().equals(EXT_ELT_SC_KIT_PROCESSOR)) {
                try {
                    Object kitProcessorObj = cfgElt.createExecutableExtension(EXT_ATT_SC_PROCESSOR_CLASS);
                    if (kitProcessorObj instanceof IRuntimeKitProcessorTemplate) {
                        return (IRuntimeKitProcessorTemplate)kitProcessorObj;
                    }
                    LOG.error((Object)this.getLogErrMsgWrongClassType(uniqueIdentifier, EXT_ATT_SC_PROCESSOR_CLASS, IRuntimeKitProcessorTemplate.class));
                }
                catch (CoreException e) {
                    LOG.error((Object)this.getLogErrMsgNotCLass(uniqueIdentifier, EXT_ATT_SC_PROCESSOR_CLASS), (Throwable)e);
                }
                return null;
            }
            ++extIndex;
        }
        return null;
    }

    private String getLogErrMsgNotCLass(String extId, String attributeName) {
        return "the 'IRuntimeKitProcessor' could not be instanciated from the extension " + extId + ". check value of the attribute '" + attributeName + "'";
    }

    private String getLogErrMsgWrongClassType(String extId, String attributeName, Class superClass) {
        return "the class specified in the attribute '" + attributeName + "' of the extension '" + extId + "' does not extend the interface '" + superClass.getCanonicalName() + "'";
    }

    private IPath getKitRootFolder(String providerExtUID) {
        String kitPath = PreferencesAccessor.getKitInstallLocation(providerExtUID);
        if ((kitPath == null || kitPath.equals("")) && (kitPath = System.getProperty("jaxws_kit_location")) == null) {
            return null;
        }
        return new Path(kitPath);
    }

    public IParameterPage getParameterPage(String id) {
        IConfigurationElement[] extElts = this.getExtension(id).getConfigurationElements();
        int extIndex = 0;
        while (extIndex < extElts.length) {
            IConfigurationElement cfgElt = extElts[extIndex];
            if (cfgElt.getName().equals(EXT_ELT_SC_W2J_GEN)) {
                try {
                    Object kitParamPageObj = cfgElt.createExecutableExtension(EXT_ATT_SC_W2J_PARAM_PAGE);
                    if (kitParamPageObj instanceof IParameterPage) {
                        return (IParameterPage)kitParamPageObj;
                    }
                    LOG.error((Object)this.getLogErrMsgWrongClassType(id, EXT_ATT_SC_W2J_PARAM_PAGE, IJavaToWsdlGenerator.class));
                }
                catch (CoreException e) {
                    LOG.error((Object)this.getLogErrMsgNotCLass(id, EXT_ATT_SC_W2J_PARAM_PAGE), (Throwable)e);
                }
                return null;
            }
            ++extIndex;
        }
        return null;
    }

    public IParameterPage getParameterPage(IProject aProject) {
        String id = this.getRuntimeProviderUID(aProject);
        return this.getParameterPage(id);
    }
}

