/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core;

import java.io.File;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IPackageCreationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PackageCreationContext
implements IPackageCreationContext {
    private IConnectionProfile mTarget;
    private File mOutputFolder;
    private File mTempFolder;
    private OverwriteCancelQuery mOverwriteCancelQuery;

    public PackageCreationContext(IConnectionProfile target, File outputFolder, File tempFolder) {
        this(target, outputFolder, tempFolder, new OverwriteCancelQuery());
    }

    public PackageCreationContext(IConnectionProfile target, File outputFolder, File tempFolder, OverwriteCancelQuery overwriteCancelQuery) {
        this.mTarget = target;
        this.mOutputFolder = outputFolder;
        this.mTempFolder = tempFolder;
        this.mOverwriteCancelQuery = overwriteCancelQuery;
    }

    public IConnectionProfile getTarget() {
        return this.mTarget;
    }

    public File getOutputFolder() {
        return this.mOutputFolder;
    }

    public File getTempFolder() {
        return this.mTempFolder;
    }

    public int promptForOverwrite(String fileName) {
        return this.mOverwriteCancelQuery.promptForOverwrite(fileName);
    }

    public static class OverwriteCancelQuery {
        private static String[] sButtonLabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
        private static int[] sResultIds = new int[]{2, 4, 3, 21, 1};
        private boolean mYesToAll = false;
        private boolean mNoToAll = false;

        int promptForOverwrite(final String fileName) {
            if (this.mYesToAll) {
                return 1;
            }
            if (this.mNoToAll) {
                return 2;
            }
            Display display = PlatformUI.getWorkbench().getDisplay();
            final int[] result = new int[1];
            display.syncExec(new Runnable(){

                public void run() {
                    boolean disposeShell = false;
                    Display display = Display.getCurrent();
                    Shell shell = display.getActiveShell();
                    if (shell == null) {
                        Shell[] shells = display.getShells();
                        if (shells.length > 0) {
                            shell = shells[shells.length - 1];
                        } else {
                            disposeShell = true;
                            shell = new Shell();
                        }
                    }
                    try {
                        MessageDialog dialog = new MessageDialog(shell, DeployCorePlugin.getDefault().getResourceString("OverwritePackageDialog.TITLE"), null, DeployCorePlugin.getDefault().getResourceString("OverwritePackageDialog.MESSAGE", new String[]{fileName}), 3, sButtonLabels, 0);
                        result[0] = dialog.open();
                    }
                    finally {
                        if (disposeShell) {
                            shell.dispose();
                        }
                    }
                }
            });
            switch (sResultIds[result[0]]) {
                case 4: {
                    this.mYesToAll = true;
                }
                case 2: {
                    return 1;
                }
                case 21: {
                    this.mNoToAll = true;
                }
                case 3: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
            }
            return 1;
        }
    }
}

