/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.tomcat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.CXFUtil;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.deploy.DeployException;
import org.eclipse.stp.sc.jaxws.utils.PackageHelper;
import org.eclipse.stp.sc.jaxws.utils.ScJDTUtils;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.stp.sc.jaxws.wsdl.WsdlUtils;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageConstructor;
import org.eclipse.stp.soas.deploy.core.IPackageCreationContext;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IServerType;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.deploy.core.ServerType;
import org.eclipse.stp.soas.deploy.core.Version;
import org.eclipse.stp.soas.deploy.tomcat.WarPackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.tomcat.WebDeployDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarDeployFilePackageConstructor
implements IPackageConstructor {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WarDeployFilePackageConstructor.class);
    private static String WAR_FILE_EXTENSION = ".war";
    private IProject project;
    private PackageHelper pkgHelper;

    public IPackageOutputDescriptor createPackage(ILogicalPackage pkg, IPackageCreationContext context, IPackageConfiguration configuration) throws CoreException {
        IFile wsdlFile = pkg.getFile();
        this.project = wsdlFile.getProject();
        File outputFolder = context.getOutputFolder();
        try {
            IContainer container = JaxWsWorkspaceManager.getWSDLFolder((IProject)this.project);
            IFile webXmlFile = ScJDTUtils.getFileFromContainer((IContainer)container, (String)"web.xml");
            if (!webXmlFile.exists()) {
                IPath path = ScJaxWsPlugin.getRuntimeProviderManager().getRuntimeKitProcessor(this.project).getInstallationDirectory();
                String webXmlFilePath = String.valueOf(path.toOSString()) + File.separator + "etc" + File.separator + "web.xml";
                LOG.debug((Object)("web.xml file to copy:" + webXmlFilePath));
                JaxWsWorkspaceManager.copyFile((String)webXmlFilePath, (IFile)webXmlFile, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
            }
            LOG.debug((Object)"generating celtix_servlet.xml...");
            this.generateServletConf(this.project, wsdlFile);
            this.project.refreshLocal(2, null);
            LOG.debug((Object)"generating war file");
            this.pkgHelper = new PackageHelper(wsdlFile, WAR_FILE_EXTENSION);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(URIUtil.toPath((URI)outputFolder.toURI()));
            IFolder folder = wsdlFile.getProject().getFolder(file.getProjectRelativePath());
            this.pkgHelper.startToPackage(folder);
            this.pkgHelper.stopPackage();
            this.project.refreshLocal(2, null);
            return new WarPackageOutputDescriptor(this.pkgHelper.getPackageFile(), pkg.getTechnologyType(), (IServerType)new ServerType("org.eclipse.stp.soas.deploy.tomcat.tomcatContainer", (IVersion)new Version(5, 5, 0, new String())), this.pkgHelper.getPackageFile().getPath(), this.pkgHelper.getPackageFile().getName());
        }
        catch (Exception e) {
            LOG.error((Object)"deploy error", (Throwable)e);
            LOG.error((Object)"create package error", (Throwable)e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.stp.soas.deploy.tomcat", 0, ScJaxWsResources.getString((String)"error.deploy.assemble"), (Throwable)e));
        }
    }

    private void generateServletConf(IProject proj, IFile wsdlFile) throws DeployException {
        try {
            String wsdlFileName = wsdlFile.getRawLocation().toOSString();
            Definition wsdlDef = WsdlUtils.readWSDL((String)wsdlFileName);
            LinkedList<WebDeployDescriptor> descList = new LinkedList<WebDeployDescriptor>();
            Map services = wsdlDef.getServices();
            Iterator itor = services.keySet().iterator();
            while (itor.hasNext()) {
                Service service = (Service)services.get(itor.next());
                Map ports = service.getPorts();
                Iterator portItor = ports.keySet().iterator();
                while (portItor.hasNext()) {
                    Port port = (Port)ports.get(portItor.next());
                    descList.add(this.generateEndpointConf(proj, wsdlFile, service, port));
                }
            }
            IFile configFile = JaxWsWorkspaceManager.getServletConfigFile((IProject)proj);
            this.writeServletConfig(configFile.getRawLocation().toOSString(), descList);
        }
        catch (WSDLException wsdlE) {
            LOG.error((Object)wsdlE);
            throw new DeployException("Wsdl parsing error during generate servlet config:" + wsdlE.toString(), (Throwable)wsdlE);
        }
        catch (CoreException coreE) {
            LOG.error((Object)coreE);
            throw new DeployException("Error during generate servlet config:" + coreE.toString(), (Throwable)coreE);
        }
    }

    private WebDeployDescriptor generateEndpointConf(IProject proj, IFile wsdlFile, Service service, Port port) throws CoreException {
        WebDeployDescriptor desc = new WebDeployDescriptor();
        desc.setWsdlPath("WEB-INF/wsdl/" + wsdlFile.getName());
        String wsdlFileName = wsdlFile.getRawLocation().toOSString();
        int index = wsdlFileName.lastIndexOf(File.separator);
        if (index >= 0) {
            wsdlFileName = wsdlFileName.substring(index + 1, wsdlFileName.length());
        }
        if ((index = wsdlFileName.lastIndexOf(".")) >= 0) {
            wsdlFileName = wsdlFileName.substring(0, index);
        }
        desc.setEndpointName(wsdlFileName);
        desc.setPattern(wsdlFileName);
        PortType portType = port.getBinding().getPortType();
        String packageName = CXFUtil.getPackageName((String)portType.getQName().getNamespaceURI());
        String interfaceName = String.valueOf(packageName) + "." + portType.getQName().getLocalPart();
        LOG.debug((Object)("[debug]interface name:" + interfaceName));
        desc.setImplClsName(JDTUtils.findImplClsName((IProject)proj, (String)interfaceName));
        LOG.debug((Object)"------- endponit cfg ------");
        LOG.debug((Object)desc.toString());
        LOG.debug((Object)"------- endponit cfg ------");
        return desc;
    }

    private void writeServletConfig(String fileName, List<WebDeployDescriptor> descList) throws DeployException {
        try {
            FileOutputStream fos = new FileOutputStream(fileName, false);
            PrintStream ps = new PrintStream(fos);
            ps.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            ps.println("<beans xmlns=\"http://www.springframework.org/schema/beans\"");
            ps.println("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
            ps.println("xmlns:jaxws=\"http://cxf.apache.org/jaxws\"");
            ps.println("xmlns:soap=\"http://cxf.apache.org/bindings/soap\"");
            ps.println("xsi:schemaLocation=\"");
            ps.println("http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.0.xsd");
            ps.println("http://cxf.apache.org/bindings/soap http://cxf.apache.org/schemas/configuration/soap.xsd");
            ps.println("http://cxf.apache.org/jaxws http://cxf.apache.org/schemas/jaxws.xsd\">");
            ps.println("\n");
            for (WebDeployDescriptor desc : descList) {
                desc.serizlize(fos);
            }
            ps.println("</beans>");
            ps.close();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            throw new DeployException("Error during write celtix-servlet.xml file", (Throwable)e);
        }
    }
}

