/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.infrastructure.operations;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;
import org.eclipse.stp.core.internal.infrastructure.emf.EMFInfrastructurePlugin;
import org.eclipse.stp.core.internal.infrastructure.emf.Messages;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;

public abstract class AbstractScribblerDataModelProvider
extends AbstractDataModelProvider
implements IAbstractScribblerDataModelProperties {
    public IStatus validate(String name) {
        if (name.equals("IAbstractScribblerDataModelProperties.SCRIBBLER_DOMAINS")) {
            return this.validateScribblerDomains();
        }
        if (name.equals("IAbstractScribblerDataModelProperties.EDIT_MODEL_LABEL")) {
            return this.validateEditModelLabel();
        }
        if (name.equals("IAbstractScribblerDataModelProperties.PROJECT_NAME")) {
            return this.validateProjectName();
        }
        return super.validate(name);
    }

    private IStatus validateEditModelLabel() {
        String editModelID = this.model.getStringProperty("IAbstractScribblerDataModelProperties.EDIT_MODEL_LABEL");
        if (editModelID == null || editModelID.length() == 0) {
            return EMFInfrastructurePlugin.createErrorStatus(0, Messages.editModelIDBlank_errorText, null);
        }
        return OK_STATUS;
    }

    private IStatus validateScribblerDomains() {
        IScribblerDomain[] domains = (IScribblerDomain[])this.model.getProperty("IAbstractScribblerDataModelProperties.SCRIBBLER_DOMAINS");
        if (domains == null || domains.length == 0) {
            return EMFInfrastructurePlugin.createErrorStatus(0, Messages.needToProvideDomains_errorText, null);
        }
        return OK_STATUS;
    }

    private IStatus validateProjectName() {
        String pName = this.getStringProperty("IAbstractScribblerDataModelProperties.PROJECT_NAME");
        if (pName.length() < 1) {
            return EMFInfrastructurePlugin.createErrorStatus(0, Messages.projectNameEmpty_errorText, null);
        }
        if (this.getProject() == null) {
            return EMFInfrastructurePlugin.createErrorStatus(0, Messages.projectDoesNotExist_errorText, null);
        }
        return OK_STATUS;
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IAbstractScribblerDataModelProperties.SCRIBBLER_DOMAINS");
        propertyNames.add("IAbstractScribblerDataModelProperties.EDIT_MODEL_LABEL");
        propertyNames.add("IAbstractScribblerDataModelProperties.PROJECT_NAME");
        propertyNames.add("IAbstractScribblerDataModelProperties.RESULT");
        return propertyNames;
    }

    public IProject getProject() {
        String pName = this.model.getStringProperty("IAbstractScribblerDataModelProperties.PROJECT_NAME");
        if (pName != null && pName.length() > 0) {
            return ProjectUtilities.getProject((String)pName);
        }
        return null;
    }
}

