/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collection;

public class StreamUtils {
    private static final byte CLASS_INT = 0;
    private static final byte CLASS_LONG = 1;
    private static final byte CLASS_BOOLEAN = 3;
    private static final byte CLASS_DOUBLE = 4;
    private static final byte CLASS_FLOAT = 5;
    private static final byte CLASS_COLLECTION = 6;
    private static final byte CLASS_STRING = 7;
    private static final byte CLASS_CHAR = 8;

    public static Object readObject(InputStream in) throws Exception {
        String claz = StreamUtils.readString(in);
        Class<?> clazz = Class.forName(claz);
        Object o = clazz.newInstance();
        int fieldcount = StreamUtils.readInt(in);
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fieldcount) {
            String fname = StreamUtils.readString(in);
            Field field = null;
            int f = 0;
            while (f < fields.length) {
                if (fields[f].getName().equals(fname)) {
                    field = fields[f];
                    break;
                }
                ++f;
            }
            if (field == null) {
                throw new Exception("Field " + fname + " not found");
            }
            field.setAccessible(true);
            int tmp = in.read();
            if (tmp == -1) {
                throw new EOFException("End of stream");
            }
            byte fclaz = (byte)tmp;
            if (fclaz == 0) {
                field.setInt(o, StreamUtils.readInt(in));
            } else if (fclaz == 1) {
                field.setLong(o, StreamUtils.readLong(in));
            } else if (fclaz == 3) {
                field.setBoolean(o, StreamUtils.readBoolean(in));
            } else if (fclaz == 4) {
                field.setDouble(o, StreamUtils.readDouble(in));
            } else if (fclaz == 5) {
                field.setFloat(o, StreamUtils.readFloat(in));
            } else if (fclaz == 8) {
                field.setChar(o, StreamUtils.readChar(in));
            } else if (fclaz == 7) {
                field.set(o, StreamUtils.readString(in));
            } else if (fclaz == 6) {
                String colname = StreamUtils.readString(in);
                Class<?> colclazz = Class.forName(colname);
                Collection col = (Collection)colclazz.newInstance();
                int colsiz = StreamUtils.readInt(in);
                int z = 0;
                while (z < colsiz) {
                    col.add(StreamUtils.readString(in));
                    ++z;
                }
                field.set(o, col);
            } else {
                throw new IllegalArgumentException("Field class " + fclaz + " not supported");
            }
            ++i;
        }
        return o;
    }

    public static void writeObject(OutputStream out, Object o) throws Exception {
        String claz = o.getClass().getName();
        StreamUtils.writeString(out, claz);
        Class<?> clazz = o.getClass();
        Field[] fields = clazz.getDeclaredFields();
        StreamUtils.writeInt(out, fields.length);
        int i = 0;
        while (i < fields.length) {
            fields[i].setAccessible(true);
            String fname = fields[i].getName();
            StreamUtils.writeString(out, fname);
            Class<?> fclazz = fields[i].getType();
            if (fclazz == Integer.TYPE) {
                out.write(0);
                StreamUtils.writeInt(out, fields[i].getInt(o));
            } else if (fclazz == Long.TYPE) {
                out.write(1);
                StreamUtils.writeLong(out, fields[i].getLong(o));
            } else if (fclazz == Boolean.TYPE) {
                out.write(3);
                StreamUtils.writeBoolean(out, fields[i].getBoolean(o));
            } else if (fclazz == Double.TYPE) {
                out.write(4);
                StreamUtils.writeDouble(out, fields[i].getDouble(o));
            } else if (fclazz == Float.TYPE) {
                out.write(5);
                StreamUtils.writeFloat(out, fields[i].getFloat(o));
            } else if (fclazz == Character.TYPE) {
                out.write(8);
                StreamUtils.writeChar(out, fields[i].getChar(o));
            } else if (fclazz == String.class) {
                out.write(7);
                String s = (String)fields[i].get(o);
                StreamUtils.writeString(out, s);
            } else if (Collection.class.isAssignableFrom(fclazz)) {
                out.write(6);
                StreamUtils.writeString(out, fclazz.getName());
                Collection col = (Collection)fields[i].get(o);
                StreamUtils.writeInt(out, col.size());
                for (String s : col) {
                    StreamUtils.writeString(out, s);
                }
            } else {
                throw new IllegalArgumentException("Field class " + fclazz + " not supported");
            }
            ++i;
        }
    }

    public static String readAllAsString(InputStream in) throws IOException {
        byte[] dat = StreamUtils.readAll(in);
        return new String(dat, 0, dat.length, "ISO-8859-1");
    }

    public static byte[] readAll(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[65536];
        int n = 0;
        while (n != -1) {
            n = in.read(buf, 0, 65536);
            if (n <= 0) continue;
            bout.write(buf, 0, n);
        }
        return bout.toByteArray();
    }

    public static byte[] readAllPossible(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[65536];
        int n = 0;
        try {
            while (n != -1) {
                n = in.read(buf, 0, 65536);
                if (n <= 0) continue;
                bout.write(buf, 0, n);
            }
        }
        catch (EOFException eOFException) {}
        return bout.toByteArray();
    }

    public static void writeBytes(OutputStream out, byte[] b) throws IOException {
        StreamUtils.writeInt(out, b.length);
        out.write(b, 0, b.length);
    }

    public static void writeBytes(OutputStream out, byte[] b, int off, int len) throws IOException {
        StreamUtils.writeInt(out, len);
        out.write(b, off, len);
    }

    public static void writeString(OutputStream out, String n) throws IOException {
        StreamUtils.writeBytes(out, n.getBytes());
    }

    public static void writeLong(OutputStream out, long n) throws IOException {
        out.write((byte)(n >>> 56));
        out.write((byte)(n >>> 48));
        out.write((byte)(n >>> 40));
        out.write((byte)(n >>> 32));
        out.write((byte)(n >>> 24));
        out.write((byte)(n >>> 16));
        out.write((byte)(n >>> 8));
        out.write((byte)n);
    }

    public static void writeDouble(OutputStream out, double n) throws IOException {
        StreamUtils.writeLong(out, Double.doubleToLongBits(n));
    }

    public static void writeInt(OutputStream out, int n) throws IOException {
        out.write((byte)(n >>> 24));
        out.write((byte)(n >>> 16));
        out.write((byte)(n >>> 8));
        out.write((byte)n);
    }

    public static void writeFloat(OutputStream out, float n) throws IOException {
        StreamUtils.writeInt(out, Float.floatToIntBits(n));
    }

    public static void writeShort(OutputStream out, short n) throws IOException {
        out.write((byte)(n >>> 8));
        out.write((byte)n);
    }

    public static void writeChar(OutputStream out, char v) throws IOException {
        out.write((byte)(0xFF & v >> 8));
        out.write((byte)(0xFF & v));
    }

    public static void writeBoolean(OutputStream out, boolean n) throws IOException {
        if (n) {
            out.write(255);
        } else {
            out.write(238);
        }
    }

    public static byte[] readBytes(InputStream in, int len) throws IOException {
        byte[] b = new byte[len];
        int red = 0;
        int tot = 0;
        while (tot < len) {
            red = in.read(b, tot, len - tot);
            if (red == -1) {
                throw new EOFException("End of stream");
            }
            tot += red;
        }
        return b;
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] readLine(InputStream in) throws IOException {
        bout = new ByteArrayOutputStream();
        last = -1;
        c = in.read();
        if (c != -1) ** GOTO lbl10
        throw new IOException("End of stream");
lbl-1000:
        // 1 sources

        {
            if (last != -1) {
                bout.write(last);
            }
            last = c;
            c = in.read();
lbl10:
            // 2 sources

            ** while (c != 10 && c != -1)
        }
lbl11:
        // 1 sources

        if (last != -1 && last != 13) {
            bout.write(last);
        }
        return bout.toByteArray();
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        int len = StreamUtils.readInt(in);
        byte[] b = new byte[len];
        int red = 0;
        int tot = 0;
        while (tot < len) {
            red = in.read(b, tot, len - tot);
            if (red == -1) {
                throw new EOFException("End of stream");
            }
            tot += red;
        }
        return b;
    }

    public static String readString(InputStream in) throws IOException {
        return new String(StreamUtils.readBytes(in));
    }

    public static byte[] readNBytes(InputStream in, int maxlen) throws IOException {
        int len = StreamUtils.readInt(in);
        if (len < 0) {
            throw new IOException("Invalid data length specified (" + len + ")");
        }
        if (len > maxlen) {
            throw new IOException("Unsafe data length specified (" + len + ")");
        }
        byte[] b = new byte[len];
        int red = 0;
        int tot = 0;
        while (tot < len) {
            red = in.read(b, tot, len - tot);
            if (red == -1) {
                throw new EOFException("End of stream");
            }
            tot += red;
        }
        return b;
    }

    public static String readNString(InputStream in, int maxlen) throws IOException {
        return new String(StreamUtils.readNBytes(in, maxlen));
    }

    public static long readLong(InputStream in) throws IOException {
        long n = 0L;
        int r = 0;
        int i = 0;
        while (i < 8) {
            r = in.read();
            if (r == -1) {
                throw new EOFException("End of stream");
            }
            n = n << 8 | (long)r;
            ++i;
        }
        return n;
    }

    public static double readDouble(InputStream in) throws IOException {
        long l = StreamUtils.readLong(in);
        return Double.longBitsToDouble(l);
    }

    public static int readInt(InputStream in) throws IOException {
        int n = 0;
        int r = 0;
        int i = 0;
        while (i < 4) {
            r = in.read();
            if (r == -1) {
                throw new EOFException("End of stream");
            }
            n = n << 8 | r;
            ++i;
        }
        return n;
    }

    public static float readFloat(InputStream in) throws IOException {
        int i = StreamUtils.readInt(in);
        return Float.intBitsToFloat(i);
    }

    public static short readShort(InputStream in) throws IOException {
        short n = 0;
        int r = 0;
        int i = 0;
        while (i < 2) {
            r = in.read();
            if (r == -1) {
                throw new EOFException("End of stream");
            }
            n = (short)(n << 8 | r);
            ++i;
        }
        return n;
    }

    public static char readChar(InputStream in) throws IOException {
        int a = in.read();
        int b = in.read();
        if (a == -1 || b == -1) {
            throw new EOFException("End of stream");
        }
        return (char)(a << 8 | b & 0xFF);
    }

    public static boolean readBoolean(InputStream in) throws IOException {
        int n = in.read();
        if (n == -1) {
            throw new EOFException("End of stream");
        }
        return n == 255;
    }
}

