/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.xpath.internal;

import java.util.ArrayList;

public abstract class XPathVisitor {
    protected ArrayList elementStack;
    protected boolean debug = false;

    public XPathVisitor() {
        if (this.debug) {
            System.out.println("Starting XPath Visitor");
        }
        this.elementStack = new ArrayList();
    }

    public XPathVisitor(boolean debug) {
        if (debug) {
            System.out.println("Starting XPath Visitor");
        }
        this.elementStack = new ArrayList();
        this.debug = debug;
    }

    public void push(Object o) {
        if (this.debug) {
            System.out.println("Pushed '" + o + "' " + o.getClass().toString());
        }
        this.elementStack.add(o);
    }

    public Object pop() {
        if (this.elementStack.size() <= 0) {
            return null;
        }
        if (this.debug) {
            System.out.println("Popped '" + this.elementStack.get(this.elementStack.size() - 1) + "'");
        }
        return this.elementStack.remove(this.elementStack.size() - 1);
    }

    public Object peek() {
        if (this.debug) {
            System.out.print("Peeking (size " + this.elementStack.size() + ")\n");
        }
        if (this.elementStack.size() <= 0) {
            return null;
        }
        return this.elementStack.get(this.elementStack.size() - 1);
    }

    public void visit(String s) {
        if (this.debug) {
            System.out.println(s);
        }
    }

    public void dumpStackContents() {
        int i = 0;
        while (i < this.elementStack.size()) {
            if (this.debug) {
                System.out.print("" + this.elementStack.get(i));
            }
            ++i;
        }
        if (this.debug) {
            System.out.println("");
        }
    }

    public abstract void prePredicateEval();

    public abstract void postPredicateEval();

    public abstract void processNumber();

    public abstract void processLiteral();

    public abstract void processSlash();

    public abstract void processAbsoluteSlash();

    public abstract void processAbbreviatedAbsoluteSlash();

    public abstract void processAbbreviatedRelativeSlash();

    public abstract void setContextNode();

    public abstract void evaluateAdditiveExpr();

    public abstract void evaluateMultiplicativeExpr();

    public abstract void evaluateUnaryExpr();

    public abstract void evaluateRelationalExpr();

    public abstract void evaluateEqualityExpr();

    public abstract void evaluateAndExpr();

    public abstract void evaluateOrExpr();

    public abstract void evaluateRelativePathPattern();

    public abstract void evaluateRelativeLocationPath();

    public abstract void evaluateStepPredicate();

    public abstract void evaluateQName();

    public abstract void evaluateQNameWONodeType();

    public abstract void evaluatePattern();

    public abstract void evaluateSingleIDKeyPattern();

    public abstract void evaluateDoubleIDKeyPattern();

    public abstract void evaluateVariableReference();

    public abstract void evaluateWildCardQName();

    public abstract void evaluateWildCardStar();

    public abstract void evaluateWildCardNCName();

    public abstract void evaluatePrimaryFilterExpr();

    public abstract void evaluatePathExpr();

    public abstract void evaluateUnionExpr();

    public abstract void evaluateAbsoluteLocationPath();

    public abstract void evaluateProcessingInstruction();

    public abstract void evaluateAbbreviatedAbsoluteLocationPath();

    public abstract void evaluateAbbreviatedRelativeLocationPath();

    public abstract void evaluateLocationIDPathPattern();

    public abstract void evaluateLocationRelPathPattern();

    public abstract void evaluateLocationPathPattern();

    public abstract void evaluateFunctionCall();

    public abstract void evaluateNodeTypeTest();

    public abstract void evaluateNameTest();

    public abstract void evaluateAxisSpecifier();

    public void evaluateAbbreviatedAxisSpecifier() {
        Object axis = this.peek();
        if (axis == null) {
            this.push("child::");
        } else if (axis.equals("@")) {
            this.pop();
            this.push("attribute::");
        } else {
            this.push("child::");
        }
        this.evaluateAxisSpecifier();
    }
}

