/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.diagram.actions.AbstractGroupUngroupAction;
import org.eclipse.stp.bpmn.diagram.edit.parts.Activity2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.LaneEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBorderCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupAction
extends AbstractGroupUngroupAction {
    public static final String ACTION_ID = "groupAction";
    public static final String TOOLBAR_ACTION_ID = "toolbarGroupAction";
    static final String ICON_PATH = "icons/Group.gif";
    private static final String ACTION_TEXT = "Group";
    static final String TOOLTIP_TEXT = "Group Shapes(Create Sub-Process)";
    private List<GraphicalEditPart> editParts = new ArrayList<GraphicalEditPart>();
    private List<IGraphicalEditPart> almostSelectedBoundaryEvents = new ArrayList<IGraphicalEditPart>();
    private Collection<SequenceEdgeEditPart> externalSrcConnections = new ArrayList<SequenceEdgeEditPart>();
    private Collection<SequenceEdgeEditPart> externalTgtConnections = new ArrayList<SequenceEdgeEditPart>();
    private Collection<SequenceEdgeEditPart> internalConnections = new HashSet<SequenceEdgeEditPart>();

    public GroupAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public GroupAction(IWorkbenchPart workbenchPart) {
        super(workbenchPart);
    }

    private static GroupAction createActionWithoutId(IWorkbenchPage workbenchPage) {
        GroupAction action = new GroupAction(workbenchPage);
        action.setText(ACTION_TEXT);
        action.setToolTipText(TOOLTIP_TEXT);
        action.setImageDescriptor(BpmnDiagramEditorPlugin.getBundledImageDescriptor(ICON_PATH));
        return action;
    }

    public static GroupAction createGroupAction(IWorkbenchPage workbenchPage) {
        GroupAction action = GroupAction.createActionWithoutId(workbenchPage);
        action.setId(ACTION_ID);
        return action;
    }

    public static GroupAction createToolbarGroupAction(IWorkbenchPage workbenchPage) {
        GroupAction action = GroupAction.createActionWithoutId(workbenchPage);
        action.setId(TOOLBAR_ACTION_ID);
        return action;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        IGraphicalEditPart firstEditPart = (IGraphicalEditPart)this.editParts.get(0);
        AbstractTransactionalCommand undoableCommand = new AbstractTransactionalCommand(firstEditPart.getEditingDomain(), "Grouping shapes", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) {
                SequenceEdge edge;
                EditPart containerEditPart = ((GraphicalEditPart)GroupAction.this.editParts.get(0)).getParent();
                CreateViewRequest req = CreateViewRequestFactory.getCreateShapeRequest((IElementType)BpmnElementTypes.SubProcess_2002, (PreferencesHint)BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                for (Object desc : req.getViewDescriptors()) {
                    CreateElementRequest createSubProcessSemanticRequest = (CreateElementRequest)((CreateViewRequest.ViewDescriptor)desc).getElementAdapter().getAdapter(CreateElementRequest.class);
                    createSubProcessSemanticRequest.setParameter("createChild", (Object)Boolean.FALSE);
                }
                Rectangle rect = GroupAction.this.getSizeAndLocation(req);
                Command create = containerEditPart.getCommand((Request)req);
                create.execute();
                Node spview = (Node)((IAdaptable)((List)req.getNewObject()).get(0)).getAdapter(Node.class);
                for (SequenceEdgeEditPart part : GroupAction.this.externalSrcConnections) {
                    edge = (SequenceEdge)part.resolveSemanticElement();
                    edge.setSource((Vertex)spview.getElement());
                    ((Edge)part.getNotationView()).setSource((View)spview);
                }
                for (SequenceEdgeEditPart part : GroupAction.this.externalTgtConnections) {
                    edge = (SequenceEdge)part.resolveSemanticElement();
                    edge.setTarget((Vertex)spview.getElement());
                    ((Edge)part.getNotationView()).setTarget((View)spview);
                }
                Bounds b = NotationFactory.eINSTANCE.createBounds();
                b.setX(rect.x);
                b.setY(rect.y);
                b.setHeight(rect.height);
                b.setWidth(rect.width);
                spview.setLayoutConstraint((LayoutConstraint)b);
                View compartmentView = null;
                String compartmentId = Integer.toString(5002);
                for (Object spchild : spview.getChildren()) {
                    View vchild = (View)spchild;
                    if (!compartmentId.equals(vchild.getType())) continue;
                    compartmentView = vchild;
                    break;
                }
                LinkedList<EObject> semantic = new LinkedList<EObject>();
                Location sploc = (Location)spview.getLayoutConstraint();
                for (Object part : GroupAction.this.editParts) {
                    View v = (View)part.getModel();
                    semantic.add(part.resolveSemanticElement());
                    compartmentView.insertChild(v);
                    if (!(v instanceof Node)) continue;
                    Bounds constraint = (Bounds)((Node)v).getLayoutConstraint();
                    constraint.setX(constraint.getX() - sploc.getX());
                    constraint.setY(constraint.getY() - sploc.getY());
                    if (constraint.getX() < 0) {
                        constraint.setX(0);
                    }
                    if (constraint.getY() >= 0) continue;
                    constraint.setY(0);
                }
                for (Object part : GroupAction.this.internalConnections) {
                    SequenceEdge edge2 = (SequenceEdge)part.resolveSemanticElement();
                    ((Graph)spview.getElement()).getSequenceEdges().add((Object)edge2);
                }
                for (EObject obj : semantic) {
                    if (obj instanceof Activity) {
                        ArrayList incoming = new ArrayList(((Activity)obj).getIncomingEdges());
                        ArrayList outgoing = new ArrayList(((Activity)obj).getOutgoingEdges());
                        ((Activity)obj).getIncomingEdges().clear();
                        ((Activity)obj).getOutgoingEdges().clear();
                        Graph graph = ((Activity)obj).getGraph();
                        graph.getVertices().remove((Object)obj);
                        ((Activity)obj).setGraph(null);
                        ((Activity)obj).setGraph((Graph)spview.getElement());
                        ((Activity)obj).getIncomingEdges().addAll(incoming);
                        ((Activity)obj).getOutgoingEdges().addAll(outgoing);
                        continue;
                    }
                    spview.getElement().eContents().add((Object)obj);
                }
                Command command = containerEditPart.getCommand(new Request((Object)"refresh"));
                command.execute();
                for (SequenceEdgeEditPart part : GroupAction.this.externalSrcConnections) {
                    part.refresh();
                    part.activate();
                }
                for (SequenceEdgeEditPart part : GroupAction.this.externalTgtConnections) {
                    part.refresh();
                    part.activate();
                }
                for (GraphicalEditPart p : GroupAction.this.editParts) {
                    for (Object connection : p.getTargetConnections()) {
                        ((EditPart)connection).refresh();
                        ((EditPart)connection).activate();
                    }
                    for (Object connection : p.getSourceConnections()) {
                        ((EditPart)connection).refresh();
                        ((EditPart)connection).activate();
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        };
        firstEditPart.getDiagramEditDomain().getDiagramCommandStack().execute((Command)new ICommandProxy((ICommand)undoableCommand));
    }

    private Rectangle getSizeAndLocation(CreateViewRequest req) {
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        boolean firstTime = true;
        for (GraphicalEditPart part : this.editParts) {
            int h;
            if (!(part.getNotationView() instanceof Node)) continue;
            LayoutConstraint constraint = ((Node)part.getNotationView()).getLayoutConstraint();
            if (constraint instanceof Location) {
                if (firstTime) {
                    firstTime = false;
                    x = ((Location)constraint).getX();
                    y = ((Location)constraint).getY();
                } else {
                    x = Math.min(((Location)constraint).getX(), x);
                    y = Math.min(((Location)constraint).getY(), y);
                }
            }
            if (!(constraint instanceof Bounds)) continue;
            int w = ((Bounds)constraint).getWidth();
            if (w == -1) {
                w = part.getFigure().getBounds().width;
            }
            if ((h = ((Bounds)constraint).getHeight()) == -1) {
                h = part.getFigure().getBounds().height;
            }
            width = Math.max(width, w + ((Bounds)constraint).getX());
            height = Math.max(height, h + ((Bounds)constraint).getY());
        }
        width -= x;
        height -= y;
        height += 32;
        Point pt = new Point(x, y);
        return new Rectangle(pt, new Dimension(width += SubProcessEditPart.INSETS.left + SubProcessEditPart.INSETS.right, height += SubProcessEditPart.INSETS.top + SubProcessEditPart.INSETS.bottom));
    }

    private void sortConnections(IGraphicalEditPart editPart, Collection<SequenceEdgeEditPart> internalConnections, Collection<SequenceEdgeEditPart> externalSrcConnection, Collection<SequenceEdgeEditPart> externalTgtConnections) {
        List srcConnections = editPart.getSourceConnections();
        for (Object connection : srcConnections) {
            if (!(connection instanceof SequenceEdgeEditPart)) continue;
            SequenceEdgeEditPart sequenceConnection = (SequenceEdgeEditPart)((Object)connection);
            if (this.editParts.contains(sequenceConnection.getTarget()) || this.almostSelectedBoundaryEvents.contains(sequenceConnection.getTarget())) {
                internalConnections.add(sequenceConnection);
                continue;
            }
            externalSrcConnection.add(sequenceConnection);
        }
        List targetConnections = editPart.getTargetConnections();
        for (Object connection : targetConnections) {
            if (!(connection instanceof SequenceEdgeEditPart)) continue;
            SequenceEdgeEditPart sequenceConnection = (SequenceEdgeEditPart)((Object)connection);
            if (this.editParts.contains(sequenceConnection.getSource()) || this.almostSelectedBoundaryEvents.contains(sequenceConnection.getSource())) {
                internalConnections.add(sequenceConnection);
                continue;
            }
            externalTgtConnections.add(sequenceConnection);
        }
    }

    public void refresh() {
        EditPart currElement;
        this.editParts.clear();
        this.almostSelectedBoundaryEvents.clear();
        this.internalConnections.clear();
        this.externalSrcConnections.clear();
        this.externalTgtConnections.clear();
        IStructuredSelection strSelection = this.getStructuredSelection();
        for (Object editPart : strSelection.toList()) {
            if (!(editPart instanceof GraphicalEditPart) || editPart instanceof Activity2EditPart) continue;
            this.editParts.add((GraphicalEditPart)editPart);
        }
        EditPart parentContainer = null;
        Iterator<GraphicalEditPart> iterator = this.editParts.iterator();
        boolean onlyArtifacts = true;
        while (iterator.hasNext()) {
            GraphicalEditPart editPart = iterator.next();
            EditPart container = editPart.getParent();
            if (!(editPart.resolveSemanticElement() instanceof Artifact)) {
                onlyArtifacts = false;
            }
            if (editPart instanceof LaneEditPart || !(container instanceof PoolPoolCompartmentEditPart) && !(container instanceof SubProcessSubProcessBodyCompartmentEditPart)) {
                this.editParts.clear();
                this.almostSelectedBoundaryEvents.clear();
                break;
            }
            if (container instanceof SubProcessSubProcessBodyCompartmentEditPart && GroupAction.isInsideAnother(container, this.editParts)) {
                iterator.remove();
                continue;
            }
            if (editPart instanceof SubProcessEditPart) {
                SubProcessSubProcessBorderCompartmentEditPart borderEditPart = (SubProcessSubProcessBorderCompartmentEditPart)((SubProcessEditPart)editPart).getChildBySemanticHintOnPrimaryView("5003");
                for (Object child : borderEditPart.getChildren()) {
                    if (!(child instanceof Activity2EditPart)) continue;
                    this.almostSelectedBoundaryEvents.add((IGraphicalEditPart)child);
                }
            }
            if (parentContainer == null) {
                parentContainer = container;
                continue;
            }
            if (parentContainer == container) continue;
            this.editParts.clear();
            this.almostSelectedBoundaryEvents.clear();
            break;
        }
        if (onlyArtifacts) {
            this.editParts.clear();
        }
        for (GraphicalEditPart editPart : this.editParts) {
            this.sortConnections((IGraphicalEditPart)editPart, this.internalConnections, this.externalSrcConnections, this.externalTgtConnections);
        }
        EditPart element = null;
        for (SequenceEdgeEditPart connection : this.externalSrcConnections) {
            currElement = connection.getSource();
            if (element == null) {
                element = currElement;
                continue;
            }
            if (element == currElement) continue;
            this.setEnabled(false);
            return;
        }
        element = null;
        for (SequenceEdgeEditPart connection : this.externalTgtConnections) {
            currElement = connection.getTarget();
            if (element == null) {
                element = currElement;
                continue;
            }
            if (element == currElement) continue;
            this.setEnabled(false);
            return;
        }
        for (GraphicalEditPart editPart : this.editParts) {
            if (!this.lookForIgnoredSequenceMembers(editPart, false, new HashSet<EditPart>())) continue;
            this.editParts.clear();
            break;
        }
        this.setEnabled(!this.editParts.isEmpty());
    }

    private boolean lookForIgnoredSequenceMembers(GraphicalEditPart editPart, boolean metIgnoredShapes, Set<EditPart> visited) {
        visited.add((EditPart)editPart);
        boolean foundIgnored = false;
        for (Object connection : editPart.getTargetConnections()) {
            if (!(connection instanceof SequenceEdgeEditPart)) continue;
            GraphicalEditPart part = (GraphicalEditPart)((ConnectionEditPart)connection).getSource();
            if (this.editParts.contains(part)) {
                if (metIgnoredShapes) {
                    return true;
                }
            } else {
                metIgnoredShapes = true;
            }
            if (visited.contains(part)) {
                return false;
            }
            boolean bl = foundIgnored = foundIgnored || this.lookForIgnoredSequenceMembers(part, metIgnoredShapes, visited);
        }
        return foundIgnored;
    }

    private static boolean isInsideAnother(EditPart editPart, List editParts) {
        SubProcessEditPart subProcess = GroupAction.getSubProcess(editPart);
        while (subProcess != null) {
            if (editParts.contains((Object)subProcess)) {
                return true;
            }
            subProcess = GroupAction.getSubProcess(subProcess.getParent());
        }
        return false;
    }
}

