/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.utils;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JarUtils;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;

public class PackageHelper {
    public static String WEB_INF_DIR = "WEB-INF/";
    public static String WSDL_DIR = String.valueOf(WEB_INF_DIR) + "wsdl/";
    public static String CLASS_DIR = String.valueOf(WEB_INF_DIR) + "classes/";
    public static String PATH_SEPERATOR = "/";
    public static String META_INF_DIR = "META-INF/";
    public static String SPRING_DIR = String.valueOf(META_INF_DIR) + "spring/";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(PackageHelper.class);
    private JarOutputStream jos;
    private IProject project;
    private IFile wsdlFile;
    private String packageExt;
    private String targetWarFile;

    public PackageHelper(IFile wsdlFile, String packageExt) {
        this.wsdlFile = wsdlFile;
        this.project = wsdlFile.getProject();
        this.packageExt = packageExt;
    }

    public void addClassFiles() throws CoreException, IOException {
        IFolder clsFolder = JaxWsWorkspaceManager.getClassesFolder(this.project);
        JarUtils.addOneTargetDir((JarOutputStream)this.jos, (IFolder)clsFolder, (String)CLASS_DIR);
    }

    public void addWsdlFiles() throws CoreException, IOException {
        IContainer wsdlFolder = JaxWsWorkspaceManager.getWSDLFolder(this.project);
        IResource[] iResourceArray = wsdlFolder.members();
        int n = 0;
        int n2 = iResourceArray.length;
        while (n < n2) {
            IResource member = iResourceArray[n];
            if (member.getType() == 1) {
                if (member.getFileExtension().equals("xml") && !member.getName().equals("spring.xml")) {
                    JarUtils.addToJar((JarOutputStream)this.jos, (String)(String.valueOf(WEB_INF_DIR) + member.getName()), (IFile)((IFile)member));
                }
                if (member.getFileExtension().equals("wsdl") || member.getFileExtension().equals("xsd")) {
                    JarUtils.addToJar((JarOutputStream)this.jos, (String)(String.valueOf(WSDL_DIR) + member.getName()), (IFile)((IFile)member));
                }
            }
            ++n;
        }
    }

    public void addFileToPackage(IResource member, String targetDir) throws CoreException, IOException {
        if (this.jos == null) {
            return;
        }
        if (member.getType() == 2) {
            String targetPath = String.valueOf(targetDir) + member.getName();
            JarUtils.addOneTargetDir((JarOutputStream)this.jos, (IFolder)((IFolder)member), (String)targetPath);
        }
        if (member.getType() != 1) {
            return;
        }
        JarUtils.addToJar((JarOutputStream)this.jos, (String)(String.valueOf(targetDir) + member.getName()), (IFile)((IFile)member));
    }

    public void startToPackage(IFolder targetFolder) throws Exception {
        try {
            if (!new File(targetFolder.getRawLocation().toOSString()).exists()) {
                targetFolder.create(true, true, null);
            }
            this.targetWarFile = this.wsdlFile.getName();
            this.targetWarFile = this.targetWarFile.substring(0, this.targetWarFile.indexOf("."));
            this.targetWarFile = String.valueOf(this.targetWarFile) + this.packageExt;
            this.targetWarFile = String.valueOf(targetFolder.getRawLocation().toOSString()) + File.separator + this.targetWarFile;
            this.jos = JarUtils.createJarOutputStream((String)this.targetWarFile);
            this.addWsdlFiles();
            this.addClassFiles();
        }
        catch (Exception e) {
            LOG.error((Object)"deploy error", (Throwable)e);
            throw e;
        }
    }

    public File getPackageFile() {
        return new File(this.targetWarFile);
    }

    public void stopPackage() throws Exception {
        try {
            this.jos.close();
        }
        catch (IOException e) {
            LOG.error((Object)"deploy error", (Throwable)e);
            throw e;
        }
    }
}

