/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.part;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnDiagramEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnNewDiagramFileWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class BpmnInitDiagramFileAction
implements IObjectActionDelegate {
    private IWorkbenchPart myPart;
    private IFile mySelectedModelFile;
    private IStructuredSelection mySelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mySelectedModelFile = null;
        this.mySelection = StructuredSelection.EMPTY;
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        this.mySelection = (IStructuredSelection)selection;
        this.mySelectedModelFile = (IFile)((IStructuredSelection)selection).getFirstElement();
        action.setEnabled(true);
    }

    public void run(IAction action) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        EObject diagramRoot = null;
        try {
            Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)this.mySelectedModelFile.getFullPath().toString()), true);
            diagramRoot = (EObject)resource.getContents().get(0);
        }
        catch (WrappedException ex) {
            BpmnDiagramEditorPlugin.getInstance().logError("Unable to load resource: " + this.mySelectedModelFile.getFullPath().toString(), ex);
        }
        if (diagramRoot == null) {
            MessageDialog.openError((Shell)this.myPart.getSite().getShell(), (String)"Error", (String)"Model file loading failed");
            return;
        }
        BpmnNewDiagramFileWizard wizard = new BpmnNewDiagramFileWizard(this.mySelectedModelFile, this.myPart.getSite().getPage(), this.mySelection, diagramRoot, editingDomain);
        IDialogSettings pluginDialogSettings = BpmnDiagramEditorPlugin.getInstance().getDialogSettings();
        IDialogSettings initDiagramFileSettings = pluginDialogSettings.getSection("InisDiagramFile");
        if (initDiagramFileSettings == null) {
            initDiagramFileSettings = pluginDialogSettings.addNewSection("InisDiagramFile");
        }
        wizard.setDialogSettings(initDiagramFileSettings);
        wizard.setForcePreviousAndNextButtons(false);
        wizard.setWindowTitle("Initialize new " + BpmnDiagramEditPart.MODEL_ID + " diagram file");
        WizardDialog dialog = new WizardDialog(this.myPart.getSite().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        dialog.open();
    }
}

