/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.swt.SWT;

public class ActivityResizeTracker
extends ResizeTracker {
    private GraphicalEditPart owner;
    private PrecisionRectangle sourceRect;
    private SnapToHelper snapToHelper;

    public ActivityResizeTracker(GraphicalEditPart owner, int direction) {
        super(owner, direction);
        this.owner = owner;
    }

    public void activate() {
        if (this.owner != null) {
            IFigure figure;
            if (this.getTargetEditPart() != null) {
                this.snapToHelper = (SnapToHelper)this.getTargetEditPart().getAdapter(SnapToHelper.class);
            }
            this.sourceRect = (figure = this.owner.getFigure()) instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)figure).getHandleBounds()) : new PrecisionRectangle(figure.getBounds());
        }
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
        this.sourceRect = null;
        this.snapToHelper = null;
    }

    protected void updateSourceRequest() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        Dimension d = this.getDragMoveDelta();
        Point location = new Point(this.getLocation());
        Point moveDelta = new Point(0, 0);
        Dimension resizeDelta = new Dimension(0, 0);
        int direction = this.getResizeDirection();
        if (this.owner != null) {
            request.setConstrainedResize(true);
            int origHeight = this.owner.getFigure().getBounds().height;
            int origWidth = this.owner.getFigure().getBounds().width;
            float ratio = 1.0f;
            if (origWidth != 0 && origHeight != 0) {
                ratio = (float)origHeight / (float)origWidth;
            }
            if (direction == 20) {
                if ((float)d.height > (float)d.width * ratio) {
                    d.width = (int)((float)d.height / ratio);
                } else {
                    d.height = (int)((float)d.width * ratio);
                }
            } else if (direction == 9) {
                if ((float)d.height < (float)d.width * ratio) {
                    d.width = (int)((float)d.height / ratio);
                } else {
                    d.height = (int)((float)d.width * ratio);
                }
            } else if (direction == 17) {
                if ((float)(-d.height) > (float)d.width * ratio) {
                    d.width = -((int)((float)d.height / ratio));
                } else {
                    d.height = -((int)((float)d.width * ratio));
                }
            } else if (direction == 12) {
                if ((float)(-d.height) < (float)d.width * ratio) {
                    d.width = -((int)((float)d.height / ratio));
                } else {
                    d.height = -((int)((float)d.width * ratio));
                }
            } else if (direction == 1) {
                direction |= 0x10;
                d.width = -((int)((float)d.height / ratio));
            } else if (direction == 4) {
                direction |= 0x10;
                d.width = (int)((float)d.height / ratio);
            } else if (direction == 16) {
                direction |= 4;
                d.height = (int)((float)d.width * ratio);
            } else if (direction == 8) {
                direction |= 4;
                d.height = -((int)((float)d.width * ratio));
            }
        } else {
            request.setConstrainedResize(false);
        }
        request.setCenteredResize(this.getCurrentInput().isModKeyDown(SWT.MOD1));
        if ((direction & 1) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                resizeDelta.height -= d.height;
            }
            moveDelta.y += d.height;
            resizeDelta.height -= d.height;
        }
        if ((direction & 4) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                moveDelta.y -= d.height;
                resizeDelta.height += d.height;
            }
            resizeDelta.height += d.height;
        }
        if ((direction & 8) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                resizeDelta.width -= d.width;
            }
            moveDelta.x += d.width;
            resizeDelta.width -= d.width;
        }
        if ((direction & 0x10) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                moveDelta.x -= d.width;
                resizeDelta.width += d.width;
            }
            resizeDelta.width += d.width;
        }
        request.setMoveDelta(moveDelta);
        request.setSizeDelta(resizeDelta);
        request.setLocation(location);
        request.setEditParts(this.getOperationSet());
        request.getExtendedData().clear();
        if (!this.getCurrentInput().isAltKeyDown() && this.snapToHelper != null) {
            PrecisionRectangle rect = this.sourceRect.getPreciseCopy();
            rect.translate(moveDelta);
            rect.resize(resizeDelta);
            PrecisionRectangle result = new PrecisionRectangle();
            this.snapToHelper.snapRectangle((Request)request, request.getResizeDirection(), rect, result);
            if (request.isCenteredResize()) {
                if (result.preciseX != 0.0) {
                    result.preciseWidth += -result.preciseX;
                } else if (result.preciseWidth != 0.0) {
                    result.preciseX = -result.preciseWidth;
                    result.preciseWidth *= 2.0;
                }
                if (result.preciseY != 0.0) {
                    result.preciseHeight += -result.preciseY;
                } else if (result.preciseHeight != 0.0) {
                    result.preciseY = -result.preciseHeight;
                    result.preciseHeight *= 2.0;
                }
                result.updateInts();
            }
            PrecisionPoint preciseMove = new PrecisionPoint(result.x + moveDelta.x, result.y + moveDelta.y);
            PrecisionDimension preciseResize = new PrecisionDimension((double)(result.width + resizeDelta.width), (double)(result.height + resizeDelta.height));
            request.setMoveDelta((Point)preciseMove);
            request.setSizeDelta((Dimension)preciseResize);
        }
    }
}

