/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.misc.internal;

public class HexData {
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static void byteToHex(byte b, StringBuffer buf) {
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private static byte hexToByte(byte b) {
        if (b >= 47 && b <= 57) {
            return (byte)(b - 48);
        }
        return (byte)(b - 55);
    }

    public static String stringToHexString(String s) {
        return HexData.byteArrayToHexString(s.getBytes());
    }

    public static String hexStringToString(String s) {
        return new String(HexData.hexStringToByteArray(s));
    }

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            HexData.byteToHex(bytes[i], sb);
            ++i;
        }
        return sb.toString();
    }

    public static byte[] hexStringToByteArray(String s) {
        byte[] string_bytes = s.getBytes();
        byte[] output_bytes = new byte[string_bytes.length / 2];
        int i = 0;
        while (i < string_bytes.length) {
            byte b;
            int hi = HexData.hexToByte(string_bytes[i]) << 4;
            byte lo = HexData.hexToByte(string_bytes[i + 1]);
            output_bytes[i / 2] = b = (byte)(hi | lo);
            i += 2;
        }
        return output_bytes;
    }
}

