/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.core.resources.IFile;


/**
 * @author rcernich
 *
 * Created on Mar 23, 2004
 */
public class DefaultSupportValidator implements ISupportValidator {

	private final String mFileExtension;

	public DefaultSupportValidator(String fileExtension) {
		super();
		mFileExtension = fileExtension;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ISupportValidator#supportsFile(org.eclipse.core.resources.IFile)
	 */
	public boolean supportsFile(IFile file) {
		return file.getFileExtension().compareTo(mFileExtension) == 0;
	}

}
