/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.stp.soas.internal.deploy.core.TechnologyType;

/**
 * @author rcernich
 * 
 * Created on Mar 25, 2004
 */
public abstract class LogicalPackageBase extends PackageBase implements
		ILogicalPackage {

	public LogicalPackageBase() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ILogicalPackage#getTechnologyType()
	 */
	public ITechnologyType getTechnologyType() {
		return new TechnologyType(
				((ILogicalPackageExtension) getExtension())
						.getSupportedTechnologyType().getTechnologyDefinition()
						.getID(), getTechnologyVersion());
	}

	protected abstract Version getTechnologyVersion(); 

}