/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.util.Assert;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType;
import org.eclipse.stp.soas.deploy.core.ITechnologyDefinition;
import org.eclipse.stp.soas.deploy.core.ITechnologyType;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.Version;


/**
 * @author rcernich
 * 
 * Created on Apr 8, 2004
 */
public class SupportedTechnologyType implements ISupportedTechnologyType {

	public static final String ATTR_TYPE = "type"; //$NON-NLS-1$
	public static final String ATTR_MIN_VERSION = "minVersion"; //$NON-NLS-1$
	public static final String ATTR_MAX_VERSION = "maxVersion"; //$NON-NLS-1$

	private IConfigurationElement mElement;
	private String mTechnologyDef;
	private IVersion mMinVersion;
	private IVersion mMaxVersion;

	public SupportedTechnologyType(IConfigurationElement element)
			throws PackageExtensionException {
		super();
		init(element);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType#getTechnologyDefinition()
	 */
	public ITechnologyDefinition getTechnologyDefinition() {
		return DeploymentExtensionManager.getInstance()
				.getTechnologyDefinition(mTechnologyDef);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType#getMinVersion()
	 */
	public IVersion getMinVersion() {
		return mMinVersion;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType#getMaxVersion()
	 */
	public IVersion getMaxVersion() {
		return mMaxVersion;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType#supportsTechnology(org.eclipse.stp.soas.deploy.core.ITechnologyType)
	 */
	public boolean supportsTechnology(ITechnologyType type) {
		boolean retVal;
		IVersion typeVersion = type.getVersion();
		if (!type.getTechnologyDefinition().equals(getTechnologyDefinition())
				|| typeVersion.compareTo(getMaxVersion()) > 0
				|| typeVersion.compareTo(getMinVersion()) < 0) {
			retVal = false;
		}
		else {
			retVal = true;
		}
		return retVal;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		if (mMinVersion.equals(mMaxVersion)) {
			buf.append(mMinVersion);
		}
		else {
			buf.append(mMinVersion).append('-').append(mMaxVersion);
		}

		return DeployCorePlugin.getDefault().getResourceString(
				"SupportedTechnologyType.toString", //$NON-NLS-1$
				new Object[] { mTechnologyDef, buf.toString()});
	}

	private void init(IConfigurationElement element)
			throws PackageExtensionException {
		Assert.isTrue(DeploymentExtensionManager.EXT_ELEM_SUPPORTED_TECHNOLOGY
				.equals(element.getName()));

		if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
			System.out
					.println(DeployCorePlugin
							.getDefault()
							.getResourceString(
									"SupportedTechnologyType.trace.processingSupportedTechnologyElement", //$NON-NLS-1$
									new Object[] {
											element.getDeclaringExtension()
													.getContributor().getName(),
											((IConfigurationElement) element
													.getParent()).getName()}));
			System.out.flush();
		}

		boolean error = false;

		mElement = element;

		mTechnologyDef = mElement.getAttribute(ATTR_TYPE);
		mMinVersion = Version.valueOf(mElement.getAttribute(ATTR_MIN_VERSION));
		mMaxVersion = Version.valueOf(mElement.getAttribute(ATTR_MAX_VERSION));
		if (mTechnologyDef == null) {
			error = true;
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.err
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"SupportedTechnologyType.trace.error.typeNotSpecified")); //$NON-NLS-1$
				System.err.flush();
			}
		}
		else if (DeploymentExtensionManager.getInstance()
				.getTechnologyDefinition(mTechnologyDef) == null) {
			error = true;
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.err
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"SupportedTechnologyType.trace.error.invalidTypeSpecified")); //$NON-NLS-1$
				System.err.flush();
			}
		}
		if (mMinVersion.compareTo(mMaxVersion) > 0) {
			error = true;
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.err
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"SupportedTechnologyType.trace.error.minVersionGreaterThanMaxVersion")); //$NON-NLS-1$
				System.err.flush();
			}
		}
		else if (mMaxVersion.compareTo(Version.NULL_VERSION) == 0) {
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.err
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"SupportedTechnologyType.trace.versionNotSpecified")); //$NON-NLS-1$
				System.err.flush();
			}
		}

		if (error) {
			throw new PackageExtensionException(
					DeployCorePlugin
							.getDefault()
							.getResourceString(
									"SupportedTechnologyType.exception.supportedTechnologyParseError")); //$NON-NLS-1$
		}
	}

}