/*******************************************************************************
 * Copyright (c) 2005-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.dialogs;

import java.util.Map;

import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;


/**
 * @author rcernich
 * 
 * Created on May 11, 2005
 */
public class PreUndeployCheckDialogPage extends BaseDeployStatusDialogPage {

	public PreUndeployCheckDialogPage(Map problemsMap, boolean allowOk) {
		super(DeployCorePlugin.getDefault().getResourceString(
				"PreUndeployCheckDialog.TITLE"), problemsMap, allowOk); //$NON-NLS-1$
	}

	protected void setStatusMessage() {
		if (mAllowOk) {
			setMessage(DeployCorePlugin.getDefault().getResourceString(
					"PreDeployCheckDialog.MESSAGE.Warnings"), WARNING); //$NON-NLS-1$
		}
		else {
			setMessage(DeployCorePlugin.getDefault().getResourceString(
					"PreUndeployCheckDialog.MESSAGE.Errors"), ERROR); //$NON-NLS-1$
		}
	}

}