/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IJavaToWsdlGenerator;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;


public class Java2WSDLAction implements IObjectActionDelegate {

    private static final LoggingProxy LOG = LoggingProxy.getlogger(Java2WSDLAction.class);

    /**
     * Constructor for Action1.
     */
    public Java2WSDLAction() {
        super();
    }

    /**
     * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
     */
    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    /**
     * @see IActionDelegate#run(IAction)
     */
    public void run(IAction action) {
        try {
            IPath path = (IPath)ResourceUtils.getSelectedResource().getFullPath();
            generate(path, ResourceUtils.getActiveProject(), null);
        } catch (Exception e) {
            LOG.error("java to wsdl action failure", e);
        }
    }

    /**
     * @see IActionDelegate#selectionChanged(IAction, ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
    
    public void generate(IPath path, IProject project, Object data) throws CoreException {
        IJavaToWsdlGenerator generator = ScJaxWsPlugin.getRuntimeProviderManager().getJavaToWsdlGenerator(project);
        if (data != null) {
            generator.setInitializationData(null, null, data);
        }
        generator.run(path, project);
    }
}
