/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.runtimeprovider;

import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

/**
 * not intended to be implemented by users
 */
public interface IRuntimeKitProcessor {

    /**
     * returns the default list of library path to add to the build path of a new project
     * of "runtimeKitRootDirectory" parameter
     */
    public List<IPath> getDefaultBuildPathEntries(IProject project);

    /**
     * returns the actual kit installation directory for the related runtime provider (could come from prefs 
     * or other settings overwritting the default one)
     * @return
     */
    public IPath getInstallationDirectory();

    /**
     * returns the default kit installation directory for the related runtime provider (to use in preferences 
     * pages for exemple)
     * @return
     */
    public IPath getDefaultInstallationDirectory();

    /**
     * validate the path provided to make sure it actually points to an installation of the provider's runtime
     * @return true if the path is correct, false otherwise
     */
    boolean isInstallationDirectoryValid(IPath installationPath);
    
    /**
     * returns the actual name of the variable that will be used to substitute the installation kit path 
     * in the project build path entries (could come from prefs or other settings overwritting the default one)
     * @return
     */
    public String getSubstitutionVarName();

    /**
     * returns the Default name of the variable that will be used to substitute the installation kit path 
     * in the project build path entries
     * @return
     */
    public String getDefaultSubstitutionVarName();

    /**
     * validates the list of proposed build path entries and return the list of invalid ones
     * @param proposedBuildPath the build path entries to validate
     * @return the list of invalid build path entries
     */
    public List<IPath> validateBuildPathEntries(List<IPath> proposedBuildPath);

    /**
     * adds the complete list of default libraries to the build path of the given java project (except for
     *  duplicates)
     * @throws CoreException 
     */
    public void completeJavaProjectBuildPath(IJavaProject project) throws JavaModelException, CoreException;

    /**
     * removes all the libraries previously added by the kit processor to given java project
     */
    public void clearJavaProjectBuildPath(IJavaProject project) throws JavaModelException, CoreException;

}