/*******************************************************************************

 * Copyright (c) 2007 IONA Technologies PLC

 * All rights reserved. This program and the accompanying materials

 * are made available under the terms of the Eclipse Public License v1.0

 * which accompanies this distribution, and is available at

 * http://www.eclipse.org/legal/epl-v10.html

 * 

 * Contributors:

 *     IONA Technologies PLC - initial API and implementation

 *******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards;


import org.eclipse.stp.sc.common.utils.FileUtils;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Text;

/**
 * @author jma
 *
 */
public class WsdlSelectionComposite extends Composite {

	
	private static final String WSDL_EXTENSION = "*.wsdl"; //$NON-NLS-1$
	
	private Group grpWSDL = null;
	public Button rbtLocalFile = null;
	public Text txtFilePath = null;
	public Button btnBrowse = null;
	public Button rbtUrl = null;
	public Text txtUrl = null;
	private Group grpDef = null;
	public Button btnFatch = null;

	public Text txtWsdl = null;
	
	private Group grpGen = null;
	public Button cbtGenCode = null;
    
    WsdlSettingPage page;

	public WsdlSelectionComposite(Composite parent, int style, WsdlSettingPage pageValue) {
		super(parent, style);
        page = pageValue;
		initialize();
	}

	private void initialize() {
		GridLayout gridLayout1 = new GridLayout();
		gridLayout1.numColumns = 1;
		createGrpWSDL();
		this.setLayout(gridLayout1);
		createGrpDef();
		createGrpCode();
	}

	/**
	 * This method initializes grpWSDL	
	 *
	 */
	private void createGrpWSDL() {
		GridData gridData1 = new GridData();
		gridData1.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData1.grabExcessHorizontalSpace = true;
		GridData gridData2 = new GridData();
		gridData2.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData2.grabExcessHorizontalSpace = true;
		GridData gridData3 = new GridData();
		gridData3.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData3.grabExcessHorizontalSpace = false;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 3;
		gridLayout.verticalSpacing = 1;
		gridLayout.horizontalSpacing = 1;
		GridData gridData = new GridData();
		gridData.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = false;
		grpWSDL = new Group(this, SWT.NONE);
		grpWSDL.setLayoutData(gridData);
		grpWSDL.setLayout(gridLayout);
		grpWSDL.setText(ScJaxWsResources.getString("JavaFirst.Wizard.wsdlsel.pagelocation")); //$NON-NLS-1$
		rbtLocalFile = new Button(grpWSDL, SWT.RADIO);
		rbtLocalFile.setText(ScJaxWsResources.getString("JavaFirst.Wizard.wsdlsel.pagefile")); //$NON-NLS-1$
		rbtLocalFile.setSelection(true);
		rbtLocalFile
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
						txtFilePath.setEnabled(true);
						btnBrowse.setEnabled(true);
						txtUrl.setEnabled(false);
						btnFatch.setEnabled(false);
						txtWsdl.setText("");
						page.setPageComplete(page.validatePage());
					}
				});
		txtFilePath = new Text(grpWSDL, SWT.BORDER);
		txtFilePath.setLayoutData(gridData2);
		//txtFilePath.setLayoutData(gridData4);
		txtFilePath.addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent event){
				txtWsdl.setText("");
				page.setPageComplete(page.validatePage());				
			}
		});
		btnBrowse = new Button(grpWSDL, SWT.NONE);
		btnBrowse.setText(ScJaxWsResources.getString("JavaFirst.Wizard.wsdlsel.pagebrowse")); //$NON-NLS-1$
		btnBrowse.setLayoutData(gridData3);
		rbtUrl = new Button(grpWSDL, SWT.RADIO);
		rbtUrl.setText(ScJaxWsResources.getString("JavaFirst.Wizard.wsdlsel.pageurl")); //$NON-NLS-1$
		btnBrowse.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				FileDialog fd = new FileDialog(getShell(), SWT.OPEN);
				fd.setText(ScJaxWsResources.getString("JavaFirst.Wizard.wsdlsel.pageselectedfile")); //$NON-NLS-1$
				fd.setFilterExtensions(new String[] {WSDL_EXTENSION});
				String wsdlPath = fd.open();
				if (wsdlPath != null && wsdlPath.length() > 0) {
					txtFilePath.setText(wsdlPath);
					txtWsdl.setText(FileUtils.getFileContent(wsdlPath));
                    page.setPageComplete(page.validatePage());
				}
			}
		});
		txtUrl = new Text(grpWSDL, SWT.BORDER);
		txtUrl.setLayoutData(gridData1);
		rbtUrl.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				txtFilePath.setEnabled(false);
				btnBrowse.setEnabled(false);
				txtUrl.setEnabled(true);
				btnFatch.setEnabled(true);
				txtWsdl.setText("");
				page.setPageComplete(false);
			}
		});
		btnFatch = new Button(grpWSDL, SWT.NONE);
		txtUrl.setEnabled(false);
		txtUrl.setLayoutData(gridData2);
		txtUrl.addModifyListener(new org.eclipse.swt.events.ModifyListener() {
			public void modifyText(org.eclipse.swt.events.ModifyEvent e) {
				txtWsdl.setText("");
				page.setPageComplete(false);				
			}
		});
		btnFatch.setEnabled(false);
		btnFatch.setText(ScJaxWsResources.getString("JavaFirst.Wizard.wsdlsel.pageconnect")); //$NON-NLS-1$
		btnFatch.setLayoutData(gridData3);
		btnFatch.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				Cursor waitCursor = null;
				
				if (txtUrl.getText() == null || txtUrl.getText().equals("")) { //$NON-NLS-1$
					return;
				}
				txtWsdl.setText(""); //$NON-NLS-1$
				try {
					waitCursor = new Cursor(Display.getCurrent(),
				        SWT.CURSOR_WAIT);
					Display.getCurrent().getActiveShell().setCursor(waitCursor);
				    txtWsdl.setText(FileUtils.getURLContent(txtUrl.getText()));
                    page.setPageComplete(page.validatePage());
				} finally {
					if (waitCursor != null) {
						Display.getCurrent().getActiveShell().setCursor(null);
						waitCursor.dispose();
					}
				}
			}
		});
	}

	/**
	 * This method initializes grpDef	
	 *
	 */
	private void createGrpDef() {
		GridData gridData6 = new GridData();
		gridData6.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData6.grabExcessHorizontalSpace = true;
		gridData6.grabExcessVerticalSpace = true;
		gridData6.verticalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridLayout gridLayout2 = new GridLayout();
		GridData gridData3 = new GridData();
		gridData3.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData3.grabExcessVerticalSpace = true;
		gridData3.grabExcessHorizontalSpace = true;
		gridData3.verticalAlignment = org.eclipse.swt.layout.GridData.FILL;
		grpDef = new Group(this, SWT.NONE);
		grpDef.setLayoutData(gridData3);
		grpDef.setLayout(gridLayout2);
		grpDef.setText(ScJaxWsResources.getString("JavaFirst.Wizard.wsdlsel.pagewsdldef")); //$NON-NLS-1$
		txtWsdl = new Text(grpDef, SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL | SWT.BORDER );
		txtWsdl.setEnabled(true);
		txtWsdl.setEditable(false);
		txtWsdl.setLayoutData(gridData6);
	}
	
	private void createGrpCode(){
		GridData gridData7 = new GridData();
		gridData7.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData7.grabExcessHorizontalSpace = true;
		gridData7.grabExcessVerticalSpace = true;
		gridData7.verticalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridLayout gridLayout2 = new GridLayout();
		GridData gridData3 = new GridData();
		gridData3.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData3.grabExcessVerticalSpace = false;
		gridData3.grabExcessHorizontalSpace = true;
		gridData3.verticalAlignment = org.eclipse.swt.layout.GridData.FILL;
		grpGen = new Group(this, SWT.NONE);
		grpGen.setLayoutData(gridData3);
		grpGen.setLayout(gridLayout2);
		grpGen.setText(ScJaxWsResources.getString("JavaFirst.Wizard.wsdlsel.pagegrpgen")); //$NON-NLS-1$
		cbtGenCode = new Button(grpGen, SWT.CHECK);
		cbtGenCode.setText(ScJaxWsResources.getString("JavaFirst.Wizard.wsdlsel.pagecbtgen"));
		cbtGenCode.setSelection(true);
		cbtGenCode.setEnabled(true);
		cbtGenCode.setLayoutData(gridData7);
		cbtGenCode.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				page.getWizard().getContainer().updateButtons();
			}
		});
	}

}
