/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.message;


import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

/**
 * @author amiguel
 * 
 * Can be used to read messages from an inputstream
 */
public class MessageReader extends Thread implements MessageConstants {

	private boolean blocking = true;

	Object mutex = new Object();
	ArrayList messages = new ArrayList();

	byte[] buffer = new byte[4096];

	InputStream in;

	/**
	 * Create a new blocking MessageReader
	 * @param in the InputStream to read messages from
	 */
	public MessageReader(InputStream in, ThreadGroup tg, String name) {
		super(tg,name);
		this.in = new BufferedInputStream(in);
	}//end method

	/**
	 * Create a new blocking MessageReader
	 * @param in the InputStream to read messages from
	 */
	public MessageReader(InputStream in) {
		this.in = new BufferedInputStream(in);
	}//end method
	
	/**
	 * Create a new MessageReader
	 * @param in the InputStream to read messages from
	 * @param whether to block upon a message read()
	 */
	public MessageReader(InputStream in, boolean blocking) {
		this.in = new BufferedInputStream(in);
		this.blocking = blocking;
		if (!blocking) {
			start();
		}//end if
	}//end method

	/**
	 * Read a message - may block or return null depending on 
	 * the users choice in the constructor
	 * @return the message read from the input stream or null if none is available
	 */
	public Message read() throws IOException {
		
		if (blocking) {
		
			return MessageUtils.readMessage(in);
		
		} else {
		
			synchronized(mutex) {
				if (messages.size() == 0) return null;
				Object o = messages.get(0);
				try {
					Message m = (Message)messages.remove(0);
					return m;
				} catch (ClassCastException e) {
					IOException x = (IOException)o;
					throw x;
				}
			}
		
		}
		
	}//end method

	public void run() {
		while(true) {
			try {
				Message m = MessageUtils.readMessage(in);
			
				synchronized(mutex) {
					messages.add(m);
				}
				
			} catch (IOException e) {
				synchronized(mutex) {
					messages.add(e);
					break;
				}
			}
		}
	}

/*

	private int readInt(InputStream i) throws IOException {
		readBytes(i,4);
	
		int x = (((int)(buffer[0] & 0xff) << 24) |
				 ((int)(buffer[1] & 0xff) << 16) |
				 ((int)(buffer[2] & 0xff) << 8) |
				 ((int)(buffer[3] & 0xff)));
	
		return x;
	}//end method
	private long readLong(InputStream i) throws IOException {
		readBytes(i,8);
	
		long x = (((long)(buffer[0] & 0xff) << 56) |
				 ((long)(buffer[1] & 0xff) << 48) |
				 ((long)(buffer[2] & 0xff) << 40) |
				 ((long)(buffer[3] & 0xff) << 32) |
				 ((long)(buffer[4] & 0xff) << 24) |
				 ((long)(buffer[5] & 0xff) << 16) |
				 ((long)(buffer[6] & 0xff) << 8) |
				 ((long)(buffer[7] & 0xff)));
	
		return x;
	}//end method
	private byte[] readBytes(InputStream i, int len) throws IOException {
	
		if (buffer.length < len) {
			buffer = new byte[len];
		}//end if
		
		int t = 0;
		int n = 0;
		
		while (t < len) {
			n = i.read(buffer,t,len-t);
			if (n == -1) {
				throw new IOException("End of Stream");
			} else {
				t+=n;
			}//end if
		}//end while

		return buffer;
	}//end method
*/
}
