/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.util.HashMap;

/**
 * 
 * @author amiguel
 *
 * A small class used in the runtime engine to parse XSD types via recursion
 * without the performance issues of a DOM tree
 */
public class CharStack {

private static final boolean DEBUG_XML = false;

char[] cs;
int cslen;
int index;

int[] marks = new int[10];
int markptr = 0;

boolean fakingEndTag = false;
int lastStartTag = -1;
int lastEndTag = -1;

//begin recent additions
boolean forward = true;

char[] rev;

	public String popUntil(String[] stop, boolean returnString) {
		char[][] ars = new char[stop.length][];
		for (int i = 0; i < stop.length; i++) {
			ars[i] = stop[i].toCharArray();
		}
		return popUntil(ars,returnString);
	}
	public String popUntil(char[][] stop, boolean returnString) {
		if (isEmpty()) return "";
	
		int n = index;
	
		boolean matched = false;
		int z = 0;
		
		while (true) {
			
	//		int matched = 0;
			for (z = 0; z < stop.length; z++) {
				for (int k = 0; k < stop[z].length; k++) {
					if (n+k < cslen && cs[n+k] == stop[z][k]) {
						if (k == stop.length-1) {
							matched = true;
						}
		//				matched++;
					} else {
						break;
					}
				}
			}
	//		if (matched == stop.length) {
			if (matched) {
				n += stop[z].length;
				break;
			}
			
			n++;
			if (n == cslen) break;
		}
		
		if (returnString) {
			if (n == index) return "";
	
			if (matched) {
//				String ret = weebleString(cs,index,(n-stop[z].length)-index);
				String ret = weebleString(cs,index,n-index);
				index = n;
				return ret;
			} else {
				String ret = weebleString(cs,index,n-index);
				index = n;
				return ret;
			}
		} else {
			index = n;
			return null;
		}
	}

	private static char[] cloneReversed(char[] tmp) {
		char[] ntmp = new char[tmp.length];
		int ni = tmp.length-1;
		for (int i = 0; i < tmp.length; i++) {
			ntmp[ni] = tmp[i];
			ni--;
		}
		return ntmp;
	}
	private static char[] cloneReversed(char[] tmp, int off, int len) {
		char[] ntmp = new char[len];
		for (int i = 0; i < len; i++) {
			ntmp[(len-1)-i] = tmp[off+i];
		}
		return ntmp;
	}
	private static char[] reverseInPlace(char[] tmp) {
		char c;
		int len = tmp.length;
		int lenm1 = tmp.length-1;
		for (int i = 0; i < len; i++) {
			c = tmp[i];
			tmp[i] = tmp[lenm1-i];
			tmp[lenm1-i] = c;
		}
		return tmp;
	}

	public CharStack switchDirection() {
		if (forward) {
			backward();
		} else {
			forward();
		}
		return this;
	}
	
	private void changeDirection() {
		forward = !forward;
		char[] tmp = rev;
		rev = cs;
		cs = tmp;
		index = cslen-index;
	}
	
	public CharStack backward() {
		if (forward) {
			if (rev == null) {
				//build the reverse array
				rev = cloneReversed(cs);
			}
			changeDirection();
		}
		return this;
	}
	
	private String weebleString(char[] cs, int off, int len) {
		if (forward) {
			return new String(cs,off,len);
		} else {
			return new String(cloneReversed(cs,off,len));
		}
	}
	
	public CharStack forward() {
		if (!forward) {
			changeDirection();
		}
		return this;
	}
//end recent additions
	
	public CharStack(String s) {
		cs = s.toCharArray();
		cslen = cs.length;
		index = 0;
	}
	public CharStack(String s, int index) {
		cs = s.toCharArray();
		cslen = cs.length;
		this.index = index;
	}
	public boolean isEmpty() {
		return index >= cslen;
	}
	public char peek() {
		return cs[index];
	}
	public char pop() {
		return cs[index++];
	}
/*	
	public String popString(String s) {
		int len = s.length();
		if (index + len >= sb.length()) return null;
		for (int i = 0; i < len; i++) {
			char c1 = s.charAt(i);
			char c2 = sb.charAt(index+i);
			if (c1 != c2) return null;
		}
		return s;
	}
*/
	public void mark() {
		marks[markptr++] = index;
//Logger.direct("PUSH MARK "+index);
		if (markptr == marks.length) {
			int[] tmp = new int[marks.length*2];
			System.arraycopy(marks,0,tmp,0,marks.length);
			marks = tmp;
		}
	}
	
	public String getSinceMark() {
		return weebleString(cs,marks[markptr-1],index-marks[markptr-1]);
	}
	
	public void resetToMark() {
		markptr--;
		if (markptr == -1) {
			markptr = 0;
		}
		index = marks[markptr];
//Logger.direct("RESET MARK "+index);
		fakingEndTag = false;
	}
	
	public void popMark() {
		markptr--;
		if (markptr == -1) {
			markptr = 0;
		}
//Logger.direct("POP (&DISCARD) MARK "+marks[markptr]);
	}
	public double peekNumber() throws NumberFormatException {
		int tmp = index;
		double d = popNumber();
		index = tmp;
		return d;
	}
	
	public double popNumber() throws NumberFormatException {
		int n = index;
		char c = cs[n];
		
//		boolean negative = (c == '-');
		if (c == '-') {
			n++;
			c = cs[n];
		}

		while (Character.isDigit(c) || c == '.') {
			n++;
			if (n == cslen) break;
			c = cs[n];
		}
		
		//scientific notation
		if (n != cslen) {
			if (cs[n] == 'E' || cs[n] == 'e') {
				n++;
				if (n != cslen) {
					if (cs[n] == '-') {
						n++;
					}
					while (Character.isDigit(cs[n])) {
						n++;
						if (n == cslen) break;
					}
				}
			}
		}
		
		if (n == index) throw new NumberFormatException("no digits found "+weebleString(cs,index,Math.min(index+5,cslen)-index));//sb.substring(index,Math.min(index+5,sblen)));
		
		double d = Double.parseDouble(weebleString(cs,index,n-index));
//		if (negative) d = -d;
		index = n;
		return d;
	}
	
	public void popWhitespace() {
		if (index == cslen) return;
		int n = index;
		char ch = cs[n];
		while (	ch == ' '
				|| ch == '\t'
				|| ch == '\n'
				|| ch == '\r'
				) {
			n++;
			if (n == cslen) break;
			ch = cs[n];
		}
		index = n;
	}
	public String popText(boolean returnString) {
		if (isEmpty()) return "";

		int n = index;

		while (	cs[n] != ' ' && cs[n] != '\t' && cs[n] != '\r' && cs[n] != '\n') {
			n++;
			if (n == cslen) break;
		}
		
		if (returnString) {
			if (n == index) return "";
	
			String ret = weebleString(cs,index,n-index);
			index = n;
			return ret;
		} else {
			index = n;
			return null;
		}
	}
	public String popUntil(String stop, boolean returnString) {
		return popUntil(stop.toCharArray(),returnString);
	}
	public String popUntil(char[] stop, boolean returnString) {
		if (isEmpty()) return "";

		int n = index;

		boolean matched = false;
		
		while (true) {
			
//			int matched = 0;
			for (int k = 0; k < stop.length; k++) {
				if (n+k < cslen && cs[n+k] == stop[k]) {
					if (k == stop.length-1) {
						matched = true;
					}
//					matched++;
				} else {
					break;
				}
			}
//			if (matched == stop.length) {
			if (matched) {
				n += stop.length;
				break;
			}
			
			n++;
			if (n == cslen) break;
		}
		
		if (returnString) {
			if (n == index) return "";
	
			if (matched) {
				String ret = weebleString(cs,index,(n-stop.length)-index);
				index = n;
				return ret;
			} else {
				String ret = weebleString(cs,index,n-index);
				index = n;
				return ret;
			}
		} else {
			index = n;
			return null;
		}
	}
	public String popUntil(char stop, boolean returnString) {
		if (isEmpty()) return "";

		int n = index;

		while (	cs[n] != stop) {
			n++;
			if (n == cslen) break;
		}
		if (n != cslen) n++;
		
		if (returnString) {
			if (n == index) return "";
	
			if (n != cslen && cs[n] == stop) {
				String ret = weebleString(cs,index,n-index);
				index = n;
				return ret;
			} else {
				String ret = weebleString(cs,index,(n-1)-index);
				index = n;
				return ret;
			}
		} else {
			index = n;
			return null;
		}
	}

	
	//////////////////////////////////////////////////
	// XML parsing stuff
	//////////////////////////////////////////////////

	public String popXmlText(boolean returnString) {
		return popXmlText(returnString,true);
	}
	
	public String popXmlText(boolean returnString, boolean skipAllNonTags) {
		if (isEmpty()) return "";

		int n = index;
		boolean hasEscaped = false;

//		#TODO check for <? in here and skip it
//		#maybe put a thing in to attempt to skip them or something?
//		#like popXmlNonTags which would pop both xml text and xml <? things
		
		StringBuffer sb = null;
		
		boolean parsingTag = false;
		
		boolean flaggy = true;
		while (flaggy) {
			flaggy = false;
			
//System.out.println(cs[n]);			
			while (	cs[n] != '<' ) {
				
				//do we have any escaped characters?
				if (cs[n] == '&') hasEscaped = true;
				
				//have we just found the end of our tag?
				if (cs[n] == '>' && parsingTag) index = n+1;
				
				n++;

				if (n == cslen) break;
			}
			
			//is this not really a tag? comment or an entity or something?
			if (skipAllNonTags && n+1 < cslen) {
				if (cs[n] == '<' && (cs[n+1] == '?' || cs[n+1] == '!')) {
					n++;
					flaggy = true;
					
					//don't include this in the text
					parsingTag = true;
//					index = n;
					
					if (sb == null) {
						sb = new StringBuffer();
					}
					sb.append(weebleString(cs,index,n-index-1));
				}
			}
		}
		
		if (returnString) {
			if (n == index) return "";
	
			String ret = weebleString(cs,index,n-index);
			
			if (sb != null) {
				ret = sb.toString() + ret;
			}
			
			//convert all the escaped characters
			if (hasEscaped) ret = XSDUtil.fromXMLString(ret);
			index = n;
			return ret;
		} else {
			index = n;
			return null;
		}
	}
	
	public String popXmlIdentifier(boolean returnString) {
		if (isEmpty()) return "";
		int n = index;
		char ch = cs[n];
		while (	   (ch > 47 && ch < 59)  // 0-9 + :
				|| (ch > 64 && ch < 91)  // A-Z
				|| (ch > 96 && ch < 123) // a-z
				|| (ch == 95)			 // _
				) {
					
			n++;
			if (n == cslen) break;
			ch = cs[n];
		}
		if (returnString) {
			if (n == index) return "";
			
			String ret = weebleString(cs,index,n-index);
			index = n;
			return ret;
		} else {
			index = n;
			return null;
		}
	}

	public String popXmlQuoted(boolean returnString) {
		if (isEmpty()) return "";
		char quote = pop(); //begin quote
		boolean hasEscaped = false;

		int n = index;
		while (cs[n] != quote) {
			
			//do we have any escaped characters?
			if (cs[n] == '&') hasEscaped = true;
			
			n++;
			if (n == cslen) break;
		}
		
		if (returnString) {
			if (n == index) return "";
	
			String ret = weebleString(cs,index,n-index);
			//convert all the escaped characters
			if (hasEscaped) ret = XSDUtil.fromXMLString(ret);
			index = n+1; //skip end quote
			return ret;
		} else {
			index = n+1; //skip end quote
			return null;
		}
	}
	
	public String popXmlElementStart() {
//		popXmlText(false);
		if (DEBUG_XML) debugStack("popXmlElementStart");		
		
		popXmlText(false,true);	//also pop any <? blah ?> tags, since they are not element tags
		
		if (DEBUG_XML) debugStack("popXmlElementStart (after initial text pop)");		
		
		if (isEmpty()) return "";

		int startIndex = index;
		
		pop(); // '<'
		if (peek() == '/') {
			pop();
			popWhitespace();
			String id = popXmlIdentifier(true);
			return "/"+id;
		} else {
			popWhitespace();
			lastStartTag = startIndex;
			String id = popXmlIdentifier(true);
			if (fakingEndTag) {
				index = lastEndTag;
				return "/"+id;
			} else {
				return id;
			}
		}
	}
	
	public void popXmlAttributes() {
		if (DEBUG_XML) debugStack("popXmlAttributes");		
		String attr=popXmlAttributeName();
		while (attr.length() > 0) {
//			popXmlAttributeValue();
			//more efficient
			popWhitespace();
			pop(); // '='
			popWhitespace();
			popXmlQuoted(false);

			attr = popXmlAttributeName();
		}
	}
	
	public HashMap popXmlAttributesAsMap() {
		HashMap map = new HashMap();
		
		if (DEBUG_XML) debugStack("popXmlAttributes");		
		String attr=popXmlAttributeName();
		while (attr.length() > 0) {
//			popXmlAttributeValue();
			//more efficient
			popWhitespace();
			pop(); // '='
			popWhitespace();
			String val = popXmlQuoted(true);

			map.put(attr,val);
			
			attr = popXmlAttributeName();
		}
		
		return map;
	}
	
	public String popXmlAttributeName() {
		if (DEBUG_XML) debugStack("popXmlAttributeName");		
		popWhitespace();
//debugStack("popXmlAttributeName");		
		return popXmlIdentifier(true);
	}
	
	public String popXmlAttributeValue() {
		if (DEBUG_XML) debugStack("popXmlAttributeValue");		
		popWhitespace();
		pop(); // '='
		popWhitespace();
//debugStack("popXmlAttributeValue");		
		return popXmlQuoted(true);
	}
	
	public void popXmlElementEnd() {
		popWhitespace();
		
		if (DEBUG_XML) debugStack("popXmlElementEnd");		
		
		if (fakingEndTag) {
			fakingEndTag = false;
			index = lastEndTag;
			if (DEBUG_XML) debugStack("(faking end tag)");
		}
		
//debugStack("popXmlElementEnd");		
		if (peek() == '/') {
			pop(); // '/'

			//we have a shorthand end tag - so fake a proper end tag
			fakingEndTag = true;
			lastEndTag = index;

			pop(); // '>'

			//jump back to the fake start tag
			index = lastStartTag;
			
		} else {
			fakingEndTag = false;
			pop(); // '>'
		}
	}
	
	public String popXmlSubTree(boolean returnString) {
		int begin = index;

		boolean done = false;

		if (DEBUG_XML) debugStack("popXmlSubTree");		
		
		while (!done) {

			//pop preceding text
			popXmlText(false);
		
			int tmp = index;
			String start = popXmlElementStart();

			if (start.length() > 0) { 
				if (start.charAt(0) == '/') {
					//end tag
					index = tmp;
					done = true;
					
				} else {
					//start tag
					popXmlAttributes();
					popXmlElementEnd();
					
					popXmlSubTree(false);
					
					popXmlElementStart();
					popXmlElementEnd();
					
				}
			} else {
				done = true;
			}
		}
		
		popXmlText(false);
		
		if (returnString) {
			return weebleString(cs,begin,index-begin);
		} else {
			return null;
		}
	}
/*
	public String popXmlSubTree(boolean returnString) {
		int begin = index;
		int end = index;
		popXmlText(false);
		
		end = index;
		String startElemName = popXmlElementStart();
		String endElemName = "/"+startElemName;
		
		while (startElemName.length() > 0) {

			//pop the attributes
			popXmlAttributes();

			//pop the end
			popXmlElementEnd();

			int depth = 0;
			
			String tmpName = popXmlElementStart();
			while (depth >= 0) {
				
				if (tmpName.equals(endElemName)) {
System.out.println("DEPTH -1 - "+tmpName);					
					depth--;
				} else if (tmpName.equals(startElemName)) {
					depth++;
				}
				
				if (depth == -1) {
					//we're finished
					popXmlElementEnd();
					
				} else {
					//we've got more elements to pop off
					
					if (tmpName.charAt(0) != '/') {
						//skip attributes of start tags
						popXmlAttributes();
					}
					
					//skip the end of this tag
					popXmlElementEnd();
					
					//get the next tag
					tmpName = popXmlElementStart();
					
					if (depth >= 0) {
						if (tmpName.length() == 0) {
							index = begin;
debugStack("ERRORRRRR");							
							return "";
						}
					}
				}
			}
			
			debugStack("END ROOT NODE");
			
			popXmlText(false);
			
			end = index;
			startElemName = popXmlElementStart();
			if (startElemName.length() > 0) {
System.out.println("START ELEM "+startElemName);				
				if (startElemName.charAt(0) == '/') {
					startElemName = "";
				}
			} else {
				popXmlText(false);
				end = index;
			}
		}
		
//		if (startElemName.charAt(0) != '/') {
//			popXmlText(false);
//			end = index;
//		}
		if (returnString) {
			return weebleString(cs,begin,end-begin);
		} else {
			return null;
		}
	}
*/
	public String toString() {
		return weebleString(cs,index,Math.min(index+20,cslen)-index)+"...";
	}
	
	public void debugStack(String s) {
		System.out.println("STACK PARSING="+s);
		System.out.println("STACK SIZE="+cslen);
		System.out.println("STACK PTR="+index);
		System.out.println("STACK FAKE END="+fakingEndTag);
//		System.out.println("STACK CONTENTS="+weebleString(cs,index,Math.min(index+20,cslen)-index)+"...");
		System.out.println("STACK CONTENTS="+weebleString(cs,index,Math.min(index+60,cslen)-index)+"...");
	}

	public String getStack() {
		return weebleString(cs,0,cslen);
	}

	private static void testXML() {
		StringBuffer sb = new StringBuffer();
		sb.append(" <\tUSAddress  \t country= \"US\">");
		sb.append(" TEXT");
		sb.append(" </USAddress> TEXT &lt;&gt;&quot;&apos;&amp;");
		CharStack cs = new CharStack(sb.toString());
		String tmp = cs.popXmlElementStart();
		if (!tmp.equals("USAddress")) {
			System.err.println("Popped element incorrectly - ["+tmp+"]");
		}
		tmp = cs.popXmlAttributeName();
		if (!tmp.equals("country")) {
			System.err.println("Popped attribute name incorrectly - ["+tmp+"]");
		}
		tmp = cs.popXmlAttributeValue();
		if (!tmp.equals("US")) {
			System.err.println("Popped attribute value incorrectly - ["+tmp+"]");
		}
		cs.popXmlElementEnd();
		tmp = cs.popXmlText(true);
		if (!tmp.equals(" TEXT ")) {
			System.err.println("Popped text incorrectly - ["+tmp+"]");
		}
		tmp = cs.popXmlElementStart();
		if (!tmp.equals("/USAddress")) {
			System.err.println("Popped element incorrectly - ["+tmp+"]");
		}
		cs.popXmlElementEnd();
		tmp = cs.popXmlElementStart();
		if (tmp.length() > 0) {
			System.err.println("popped element name from text - ["+tmp+"]");
		}
		if (!cs.isEmpty()) System.err.println("Finished reading all XML but not empty??");

		sb = new StringBuffer();
//		sb.append("TEXT1 TEXT2 <node1 blah=\"abcd\" > OTHER TEXT1 <MINI NODE /> OTHER TEXT2 </ node1 > TEXT3");
		sb.append("OTHER TEXT1 <MINI_NODE /> OTHER TEXT2 <N1><N2><MINI_NODE2 /></N2></N1> OTHER TEXT3 </flinder>");
//		sb.append("OTHER TEXT1 <MINI_NODE /> OTHER TEXT2 <N1><N2><MINI_NODE2 /></N2></N1> OTHER TEXT3 ");
		cs = new CharStack(sb.toString());
//cs.popXmlText(false);		
		String ret = cs.popXmlSubTree(true);
		if (!ret.equals("OTHER TEXT1 <MINI_NODE /> OTHER TEXT2 <N1><N2><MINI_NODE2 /></N2></N1> OTHER TEXT3 ")) {
			System.out.println("Popped subtree incorrectly:["+ret+"]");
		} else {
			System.out.println("Popped subtree correctly:"+ret);
		}
		
		String soapTest = "   <result xsi:type=\"ns2:string\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ns2=\"http://www.w3.org/2001/XMLSchema\">ni hao</result>";
		cs = new CharStack(soapTest);
		cs.popXmlText(false);
		tmp = cs.popXmlElementStart();
		if (!tmp.equals("result")) {
			System.out.println("popped SOAP element incorrectly - ["+tmp+"]");
		} else {
			System.out.println("popped SOAP element OK - ["+tmp+"]");
		}
		   		
		//comment test
		
		String commentTest = "  <TAG> some <!-- COMMENT --><!--comment 2--> te<!--comment3-->xt </TAG>";
		cs = new CharStack(commentTest);
		cs.popXmlElementStart();
		cs.popXmlAttributes();
		cs.popXmlElementEnd();
		String txt = cs.popXmlText(true);
		if (txt.equals(" some  text ")) {
			System.out.println("popped xml text interspersed with comments OK ["+txt+"]");
		} else {
			System.out.println("popped xml text interspersed with comments incorrectly ["+txt+"]");
		}
	}
	
	public static void main(String[] args) {
		testXML();
		
		CharStack cs = new CharStack(args[0]);
		cs.popXmlElementStart();
		cs.popXmlAttributes();
		cs.popXmlElementEnd();
		
		while (!cs.isEmpty()) {
			cs.popXmlElementStart();
			cs.popXmlAttributes();
			cs.popXmlElementEnd();
		}		
	}
}