/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport.SessionTransportLoader;
import org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport.SessionTransportProvider;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingLoader;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingTranslator;
import org.eclipse.stp.b2j.ui.internal.misc.Debugger;
import org.eclipse.stp.b2j.ui.internal.preferences.PreferenceConstants;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class UiPlugin extends AbstractUIPlugin {

	public static final String EXTENSION_POINT_BPELPROVIDER = "org.eclipse.stp.b2j.ui.BpelProvider";

	public static final String EXTENSION_BPELPROVIDER_WORKSPACEFILE = "org.eclipse.stp.b2j.core.providers.file.workspacefile";
	public static final String EXTENSION_BPELPROVIDER_LOCALFILE = "org.eclipse.stp.b2j.core.providers.file.localfile";
	public static final String EXTENSION_BPELPROVIDERCATEGORY_FILE = "org.eclipse.stp.b2j.core.providers.file";
	
	
	public static Debugger DBG = new Debugger(UiPlugin.class.getPackage().getName());
	
	public static B2jImageManager imageManager = B2jImageManager.INSTANCE;
	
	//The shared instance.
	private static UiPlugin plugin;
	
	/**
	 * The constructor.
	 */
	public UiPlugin() {
		plugin = this;

		imageManager.initialize("icons/full/",this,"org.eclipse.stp.b2j.ui");
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static UiPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.stp.b2j.ui", path);
	}

	protected void initializeDefaultPreferences(IPreferenceStore store) {
		// These settings will show up when Preference dialog
		// opens up for the first time.
		store.setDefault(PreferenceConstants.USE_PROXY, false);
		store.setDefault(PreferenceConstants.PROXY_PORT, 8080);
		store.setDefault(PreferenceConstants.PROXY_HOST, "http-proxy");
		
		store.setDefault(PreferenceConstants.USE_CACHE, true);
		
		try {
			WSDLBindingTranslator[] translators = WSDLBindingLoader.getBindingsUnfiltered();
			for (int i = 0; i < translators.length; i++) {
				String key = PreferenceConstants.getBindingEnabledKey(translators[i]);
				if (!store.contains(key)) {
					store.setValue(key,true);
				}
			}
		} catch (Exception e) {
		}
		
		try {
			SessionTransportProvider[] providers = SessionTransportLoader.getTransportsUnfiltered();
			for (int i = 0; i < providers.length; i++) {
				String key = PreferenceConstants.getTransportEnabledKey(providers[i]);
				if (!store.contains(key)) {
					store.setValue(key,true);
				}
			}
		} catch (Exception e) {
		}
		
		//Dont allow disabling of the internal binding type
//		store.setValue(PreferenceConstants.getBindingEnabledKey(new InternalMessageBindingTranslator()),true);
	}
	
	//
	// Plugin.properties string stuff
	//
	
	private ResourceBundle resourceBundle;

	private void loadResourceBundle() {
		if (resourceBundle == null) {
			resourceBundle = Platform.getResourceBundle(getBundle());
		}
	}
	
	public static String getString(String key) 
	{
		getDefault().loadResourceBundle();
		try
		{
			String ret = getDefault().resourceBundle.getString(key);
			if (ret == null) return key;
			return ret;
		}
		catch (NullPointerException e)
		{
			return key;
		}
		catch (MissingResourceException e)
		{
			return key;
		}
	}
	
	public static String getString(String key, String arg)
	{
		getDefault().loadResourceBundle();
		return getString(key, new String[]{arg});
	}
	
	public static String getString(String key, String[] args)
	{
		getDefault().loadResourceBundle();
		return replaceString(getDefault().resourceBundle.getString(key),args);
	}
	
	private static String replaceString(String key, String[] args) {
		StringBuffer sb = new StringBuffer(key);

		for (int i = 0; i < args.length; i++) {
			if (args[i] == null) continue;

			String search = "%"+(i+1);
			int searchlen = search.length();

			int n = indexOf(sb,search,0);	
//			int n = sb.indexOf(search);
			while (n != -1) {
				sb.replace(n,n+searchlen,args[i]);
//				n = sb.indexOf(search,n);
				n = indexOf(sb,search,n);
			}
		}
		
		return sb.toString();
	}
	

	public static int indexOf(StringBuffer in, String str, int fromIndex)
	{
		if(in == null)
			return -1;
		
		if(str == null)
			str = "";
			
		int lengthIn = in.length();
		int lengthStr = str.length();

		if(lengthIn < lengthStr)
			return -1;

		if(fromIndex > lengthIn)
		{
			if (lengthIn == 0 && fromIndex == 0 && lengthStr == 0)
				return 0;
			return -1;
		}
		
		if(fromIndex < 0)
			fromIndex = 0;
			
		if(lengthStr == 0)
			return fromIndex;
			
		int strPos = 0;
		for(int i=fromIndex; i<lengthIn; i++)
		{
			if(in.charAt(i) == str.charAt(strPos))
			{
				strPos++;
				if(strPos == lengthStr)
					return i-lengthStr+1;
			}
			else
				strPos = 0;	
		}
		
		return -1;
	}
	
}
