/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/

/**
 * Date             Author              Changes
 * Jul 17, 2006     hmalphettes         Created
 **/

package org.eclipse.stp.bpmn.commands;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.SubProcess;

/**
 * Support for the {@link IElementTypeEx} to set the activityType
 * 
 * @author hmalphettes
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class CreateElementCommandEx extends CreateElementCommand {

    public CreateElementCommandEx(CreateElementRequest request) {
        super(request);
    }

    /**
     * 
     * 
     * @return the new model element that has been created
     */
    protected EObject doDefaultElementCreation() {
        EReference containment = getContainmentFeature();
        EClass eClass = getElementType().getEClass();

        if (containment != null) {
            EObject element = getElementToEdit();

            if (element != null) {
            	
                EObject res = EcoreUtil.create(eClass);/*EMFCoreUtil.create(element, containment, eClass);*/
                if (res instanceof Activity || res instanceof SubProcess) {
                    if (getElementType() instanceof ElementTypeEx) {
                        String secondarySemanticHint = ((IElementTypeEx) getElementType())
                                .getSecondarySemanticHint();
                        
                        if (BpmnPackage.Literals.ACTIVITY__LOOPING.getName()
                                .equals(secondarySemanticHint)) {
                            if (res instanceof Activity) {
                                ((Activity) res).setLooping(true);
                            } else {
                                ((SubProcess) res).setLooping(true);
                            }
                        } else if (res instanceof Activity) {
                            
                            ActivityType at = ActivityType
                                    .getByName(secondarySemanticHint);
                            if (at != null) {
                                ((Activity) res).setActivityType(at);
                            }
                        }
                    }
                }
                if (FeatureMapUtil.isMany(element, containment)) {
        			((Collection) element.eGet(containment)).add(res);
        		} else {
        			element.eSet(containment, res);
        		}
                return res;
            }
        }
        return null;
    }
}
