/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.soas.deploy.tomcat.wtp;

import java.util.Properties;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.stp.soas.deploy.core.adapters.IWTPServerAdapter;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;

/**
 * This class is used to convert Tomcat server in WTP
 * to connection profile defined in stp.
 * So we can deploy war file into wtp's tomcat server
 * @author jma
 *
 */
public class WtpTomcatServerAdapter implements IWTPServerAdapter {

	
	IServer wtpServer = null;
	String connectionProfileID = null;
	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.core.wtpbridge.IWTPServerAdapter#setProviderID(java.lang.String)
	 */
	public void setProviderID(String provider) {
		connectionProfileID = provider;
	}

	/* 
	 * return the ConnectionProfille from WTP server
	 * 
	 */
	@SuppressWarnings("unchecked")
	public IConnectionProfile asConnectionProfile() {
		try {
			String profileName = wtpServer.getName();
			String profileDesc = wtpServer.getServerType().getDescription();
			String profileProviderID = connectionProfileID;

			ConnectionProfileProvider mProvider = (ConnectionProfileProvider) ConnectionProfileManager
					.getInstance().getProvider(profileProviderID);

			ConnectionProfile cp = new ConnectionProfile(profileName,
					profileDesc, profileProviderID);
			cp.setAutoConnect(false);
			Properties props = new Properties();
			Server svr = (Server) wtpServer;
			ILaunchConfiguration cfg = svr.getLaunchConfiguration(true, null);
			String deployDir = getDeployDir(cfg);
			if (deployDir != null) {
				props.setProperty("catalina.deploy", deployDir);
			}
			String installDir = getServerInstallDir(cfg);
			props.setProperty("dir", installDir);
			cp.setBaseProperties(props);
			return cp;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public void setWtpServer(IServer server) {
		wtpServer = server;
	}
	
	/**
     * get the server working dir from server launch configuration
     * @param cfg
     * @return
     * @throws CoreException 
     */
    private String getServerInstallDir(ILaunchConfiguration cfg) throws CoreException {
    	return getAttrSegment(cfg, "org.eclipse.jdt.launching.VM_ARGUMENTS", "-Dcatalina.base=\"");
    }
    
    
    
    /**
     * get the deploy dir from server launch configuration
     * @param cfg
     * @return
     * @throws CoreException 
     */
    private String getDeployDir(ILaunchConfiguration cfg) throws CoreException {
    	return getAttrSegment(cfg, "org.eclipse.jdt.launching.VM_ARGUMENTS", "-Dcatalina.deploy=\"");
//    	-Dcatalina.deploy
//    	-Dcatalina.base
//    	-Dcatalina.home
    	
    }
    
    private String getAttrSegment(ILaunchConfiguration cfg, String attrName, String segmentName) throws CoreException {
    	String vmArgs = cfg.getAttribute(attrName, "");
    	if (vmArgs == null || vmArgs.equals("")) {
    		return null;
    	}
    	
    	if (vmArgs.indexOf(segmentName) < 0) {
    		return null;
    	}
    	String deployDir = vmArgs.substring(
    			vmArgs.indexOf(segmentName) + segmentName.length());
    	deployDir = deployDir.substring(0, 
    			deployDir.indexOf("\""));
    	return deployDir;
    }

}
