/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
/*
 * Created on Mar 22, 2005
 *
 * Copyright 2005 by IONA Technologies PLC, Inc.
 *
 * All rights reserved.
 *
 */

package org.eclipse.stp.sc.cxf.launchers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

import org.eclipse.stp.common.logging.LoggingProxy;

public class JavaLaunchConfig  implements IJavaLaunchConfigurationConstants {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JavaLaunchConfig.class);
    private String configBaseName = null;
    private String projectName = null;
    private String programArgs = null;
    private String serverMainClassName = null;
    private String clientMainClassName = null;
    
    public JavaLaunchConfig() {
        //complete
    }
    
    public void setClientMainClassName(String clientMainClassNameStr) {
        this.clientMainClassName = clientMainClassNameStr;
    }

    public void setServerMainClassName(String serverMainClassNameStr) {
        this.serverMainClassName = serverMainClassNameStr;
    }

    public void setProjectName(String projectNameStr) {
        this.projectName = projectNameStr;
    }

    public void setProgramArgs(String programArgsStr) {
        this.programArgs = programArgsStr;
    }
    
    public void setConfigBaseName(String configBaseNameStr) {
        this.configBaseName = configBaseNameStr;
    }

    public void createServerLaunchConfig() {
        if ((configBaseName != null) && (projectName != null) && (serverMainClassName != null)) {
            LOG.debug("server config configBaseName: " + configBaseName);
            LOG.debug("server config projectName: " + projectName);
            LOG.debug("server config serverMainClassName: " + serverMainClassName);
            this.createLaunchConfig(serverMainClassName, "server_" + projectName);
        }
    }

    public void createClientLaunchConfig() {
        if ((configBaseName != null) && (projectName != null) && (clientMainClassName != null)) {
            LOG.debug("client config configBaseName: " + configBaseName);
            LOG.debug("client config projectName: " + projectName);
            LOG.debug("client config clientMainClassName: " + clientMainClassName);
            this.createLaunchConfig(clientMainClassName, "client_" + projectName);
        }
    }

    private void createLaunchConfig(String mainClassName, String id) {
        String launchConfigName = configBaseName + "_" + id;
        LOG.debug("run/debug config name: " + launchConfigName);

        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(ID_JAVA_APPLICATION);
        
        try {
            ILaunchConfiguration[] configurations = manager.getLaunchConfigurations(type);
            for (int i = 0; i < configurations.length; i++) {
                ILaunchConfiguration configuration = configurations[i];
                if (configuration.getName().equals(launchConfigName)) {
                    configuration.delete();
                    break;
                    
                }
            }

            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, launchConfigName);

            //set project name and main class
            workingCopy.setAttribute(ATTR_PROJECT_NAME, projectName);
            workingCopy.setAttribute(ATTR_MAIN_TYPE_NAME, mainClassName);
            workingCopy.setAttribute(ATTR_PROGRAM_ARGUMENTS, programArgs);
            
            //save the run config
            workingCopy.doSave();
        } catch (CoreException ex) {
            LOG.debug("Exception thrown trying to create run config");
        }
    }

}
