/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca.impl;

import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentWireHandle;

abstract class ComponentWireHandleImpl extends SCAObjectImpl implements
      ComponentWireHandle {
   private Component component;

   ComponentWireHandleImpl(Component component) {
      Assert.isNotNull(component);
      this.component = component;
   }

   void destroy() {
      this.component = null;
   }

   public Component getOwningComponent() {
      return component;
   }

   /**
    * Return true that this wire handle originates from a {@link Component}.
    * 
    * @return boolean
    */
   public boolean isComponentOwned() {
      return true;
   }

}
