/**
 * <copyright> </copyright>
 * 
 * $Id: SystemWireItemProvider.java,v 1.2 2006/04/05 14:26:13 melder Exp $
 */
package org.eclipse.stp.core.sca.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.SystemWire;

/**
 * This is the item provider adapter for a
 * {@link org.eclipse.stp.core.sca.SystemWire} object. <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * 
 * @generated
 */
public class SystemWireItemProvider extends ItemProviderAdapter implements
      IEditingDomainItemProvider, IStructuredItemContentProvider,
      ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * This constructs an instance from a factory and a notifier. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public SystemWireItemProvider(AdapterFactory adapterFactory) {
      super(adapterFactory);
   }

   /**
    * This returns the property descriptors for the adapted class. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getPropertyDescriptors(Object object) {
      if (itemPropertyDescriptors == null) {
         super.getPropertyDescriptors(object);

      }
      return itemPropertyDescriptors;
   }

   /**
    * This specifies how to implement {@link #getChildren} and is used to deduce
    * an appropriate feature for an
    * {@link org.eclipse.emf.edit.command.AddCommand},
    * {@link org.eclipse.emf.edit.command.RemoveCommand} or
    * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Collection getChildrenFeatures(Object object) {
      if (childrenFeatures == null) {
         super.getChildrenFeatures(object);
         childrenFeatures.add(SCAPackage.eINSTANCE.getSystemWire_SourceGroup());
         childrenFeatures.add(SCAPackage.eINSTANCE.getSystemWire_TargetGroup());
         childrenFeatures.add(SCAPackage.eINSTANCE.getSystemWire_Any());
      }
      return childrenFeatures;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EStructuralFeature getChildFeature(Object object, Object child) {
      // Check the type of the specified child object and return the proper
      // feature to use for
      // adding (see {@link AddCommand}) it as a child.

      return super.getChildFeature(object, child);
   }

   /**
    * This returns SystemWire.gif. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object getImage(Object object) {
      return getResourceLocator().getImage("full/obj16/SystemWire"); //$NON-NLS-1$
   }

   /**
    * This returns the label text for the adapted class. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getText(Object object) {
      return getString("_UI_SystemWire_type"); //$NON-NLS-1$
   }

   /**
    * This handles model notifications by calling {@link #updateChildren} to
    * update any cached children and by creating a viewer notification, which it
    * passes to {@link #fireNotifyChanged}. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   public void notifyChanged(Notification notification) {
      updateChildren(notification);

      switch (notification.getFeatureID(SystemWire.class)) {
         case SCAPackage.SYSTEM_WIRE__SOURCE_GROUP:
         case SCAPackage.SYSTEM_WIRE__TARGET_GROUP:
         case SCAPackage.SYSTEM_WIRE__ANY:
            fireNotifyChanged(new ViewerNotification(notification, notification
                  .getNotifier(), true, false));
            return;
      }
      super.notifyChanged(notification);
   }

   /**
    * This adds to the collection of
    * {@link org.eclipse.emf.edit.command.CommandParameter}s describing all of
    * the children that can be created under this object. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected void collectNewChildDescriptors(Collection newChildDescriptors,
         Object object) {
      super.collectNewChildDescriptors(newChildDescriptors, object);

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createAbstractImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createComponentType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createComposite())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createEntryPoint())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createExternalService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createImplementationComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createJavaImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createJavaInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createModuleFragment())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createModule())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createModuleComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createReference())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createModuleReference())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createModuleService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createModuleWire())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createProperty())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createPropertyValue())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createPropertyValuesSet())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createReferenceValue())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createReferenceValuesSet())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createSCABinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createSLSBBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createSubsystem())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createSystemWire())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createUnknownImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createWebServiceBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Source(), SCAFactory.eINSTANCE
                  .createWSDLPortType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createAbstractImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createComponentType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createComposite())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createEntryPoint())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createExternalService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createImplementationComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createJavaImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createJavaInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createModuleFragment())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createModule())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createModuleComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createReference())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createModuleReference())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createModuleService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createModuleWire())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createProperty())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createPropertyValue())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createPropertyValuesSet())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createReferenceValue())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createReferenceValuesSet())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createSCABinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createSLSBBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createSubsystem())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createSystemWire())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createUnknownImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createWebServiceBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createWSDLPortType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_SourceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceUri(), ""))); //$NON-NLS-1$

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createAbstractImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createComponentType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createComposite())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createEntryPoint())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createExternalService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createImplementationComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createJavaImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createJavaInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createModuleFragment())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createModule())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createModuleComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createReference())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createModuleReference())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createModuleService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createModuleWire())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createProperty())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createPropertyValue())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createPropertyValuesSet())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createReferenceValue())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createReferenceValuesSet())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createSCABinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createSLSBBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createSubsystem())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createSystemWire())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createUnknownImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createWebServiceBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSystemWire_Target(), SCAFactory.eINSTANCE
                  .createWSDLPortType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createAbstractImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createComponentType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createComposite())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createEntryPoint())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createExternalService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createImplementationComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createJavaImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createJavaInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createModuleFragment())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createModule())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createModuleComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createReference())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createModuleReference())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createModuleService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createModuleWire())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createProperty())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createPropertyValue())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createPropertyValuesSet())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createReferenceValue())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createReferenceValuesSet())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createSCABinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createSLSBBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createSubsystem())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createSystemWire())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createUnknownImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createWebServiceBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createWSDLPortType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSystemWire_TargetGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetUri(), ""))); //$NON-NLS-1$
   }

   /**
    * This returns the label text for
    * {@link org.eclipse.emf.edit.command.CreateChildCommand}. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getCreateChildText(Object owner, Object feature, Object child,
         Collection selection) {
      Object childFeature = feature;
      Object childObject = child;

      if (childFeature instanceof EStructuralFeature
            && FeatureMapUtil.isFeatureMap((EStructuralFeature) childFeature)) {
         FeatureMap.Entry entry = (FeatureMap.Entry) childObject;
         childFeature = entry.getEStructuralFeature();
         childObject = entry.getValue();
      }

      boolean qualify = childFeature == SCAPackage.eINSTANCE
            .getSystemWire_Source()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr()
            || childFeature == SCAPackage.eINSTANCE.getSystemWire_Target()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr();

      if (qualify) {
         return getString("_UI_CreateChild_text2", //$NON-NLS-1$
               new Object[] { getTypeText(childObject),
                     getFeatureText(childFeature), getTypeText(owner) });
      }
      return super.getCreateChildText(owner, feature, child, selection);
   }

   /**
    * Return the resource locator for this item provider's resources. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ResourceLocator getResourceLocator() {
      return STPCorePlugin.INSTANCE;
   }

}
