/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap;

import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDRootElement;

/**
 * 
 * @author amiguel
 *
 * A class to represent a BPEL variable property
 */
public class BPELPropertyAlias {
	String qpropertyName;
	
	String qmessageType;
	String messagePart;
	//OR
	String qxsdType;
	//OR
	String qxsdElement;
	
	String query;
	
	public String getQualifiedPropertyName() {
		return qpropertyName;
	}
	
	public String getQualifiedWsdlMessageType() {
		return qmessageType;
	}
	public String getWsdlMessagePart() {
		return messagePart;
	}
	public String getQualifiedXsdElementType() {
		return qxsdElement;
	}
	public String getQualifiedXsdType() {
		return qxsdType;
	}
	
	public String getQualifiedUnderlyingXsdType(WSDLMap wsdlmap, XSDMap xsdmap) throws Exception {
		
		if (qmessageType != null) {
			WSDLMessage msg = wsdlmap.getMessage(qmessageType);
			if (msg == null) {
				throw new Exception("message type "+qmessageType+" not found for aliased property "+qpropertyName);
			}
			return msg.getPartType(messagePart);
		}
		if (qxsdElement != null) {
			XSDRootElement elem = xsdmap.getRootElementTypeByQName(qxsdElement);
			if (elem == null) {
				throw new Exception("XSD element "+qxsdElement+" not found for aliased property "+qpropertyName);
			}
			return elem.getQualifiedType();
		}
		
		return qxsdType;
		
	}
	
	public String getQuery() {
		return query;
	}
}