/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.WSEndpointReference;

/**
 * 
 * @author amiguel
 *
 * A simple class to test the SOAP implementation used in the SOAP binding
 */
public class SOAPTest {
	public static void main(String[] args) {
		try {
			//temperature service
			WSEndpointReference epr;
			
			epr = new WSEndpointReference("http://services.xmethods.net:80/soap/servlet/rpcrouter");
			
			String response = SOAPClient.invokeRequestResponse(epr,null,null,true,"urn:xmethods-Temperature","getTemp","","<zipcode xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/1999/XMLSchema\" xsi:type=\"xsd:string\">11217</zipcode>");
			System.out.println("RESPONSE:"+response);


			epr = new WSEndpointReference("http://services.xmethods.net:80/soap");

			response = SOAPClient.invokeRequestResponse(epr,null,null,true,"urn:xmethods-CurrencyExchange","getRate","","<country1 xsi:type=\"xsd:string\">UK</country1>"
																						     +"<country2 xsi:type=\"xsd:string\">US</country2>");
			System.out.println("RESPONSE:"+response);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}