/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.delete.operations;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerOperation;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class DeleteServiceOperation
extends AbstractScribblerOperation {
    public DeleteServiceOperation(IDataModel model) {
        super(model);
    }

    protected IStatus doExecute(IProgressMonitor monitor) throws ExecutionException {
        IStatus status = OK_STATUS;
        ComponentType cType = (ComponentType)this.model.getProperty("IDeleteInterfaceDataModelProperties.COMPONENT_TYPE");
        List services = cType.getServices();
        if (services.isEmpty()) {
            return OK_STATUS;
        }
        String[] serviceNames = (String[])this.model.getProperty("IDeleteInterfaceDataModelProperties.SERVICE_NAMES");
        Assert.isTrue((services.size() >= serviceNames.length ? 1 : 0) != 0);
        int i = 0;
        while (i < serviceNames.length) {
            Service service = null;
            int serviceIndex = 0;
            while (serviceIndex < services.size()) {
                service = (Service)services.get(serviceIndex);
                if (service.getName().equals(serviceNames[i])) break;
                service = null;
                ++serviceIndex;
            }
            if (service != null) {
                cType.getServices().remove(service);
            }
            ++i;
        }
        return status;
    }

    protected IStatus doRedo(IProgressMonitor monitor) throws ExecutionException {
        return null;
    }

    protected IStatus doUndo(IProgressMonitor monitor) throws ExecutionException {
        return null;
    }
}

