/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.introspection.module;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModelFactory;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.infrastructure.emf.WorkbenchResourceHelper;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.introspection.AbstractComponentTypeIntrospector;
import org.eclipse.stp.core.introspection.IComponentTypeIntrospector;
import org.eclipse.stp.core.resources.CompositeScribblerDomain;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.Module;
import org.eclipse.stp.core.sca.ModuleReference;
import org.eclipse.stp.core.sca.ModuleService;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.Service;

public class ModuleComponentTypeIntrospector
extends AbstractComponentTypeIntrospector
implements IComponentTypeIntrospector {
    private IEditModelScribbler scribbler;
    private Module module;
    private CompositeScribblerDomain domain;
    private boolean disposed = false;

    protected void doInit() {
        URI platformURI = this.getImplementationURI().replacePrefix(URI.createURI((String)"comptype:/"), URI.createURI((String)"platform:/resource/"));
        IFile moduleFile = WorkbenchResourceHelper.getPlatformFile((URI)platformURI);
        this.domain = new CompositeScribblerDomain(moduleFile);
    }

    protected IStatus doIntrospection(int theFieldType, List theCurrentValues) {
        if (this.disposed) {
            return STPCorePlugin.createErrorStatus(0, "ModuleComponentTypeIntrospector is already disposed in doIntrospection()!", null);
        }
        Module module = this.getModule();
        if (module == null) {
            return this.hasValidComponentType();
        }
        switch (theFieldType) {
            case 0: {
                List entryPoints = module.getEntryPoints();
                ModuleService moduleService = null;
                EntryPoint entryPoint = null;
                ArrayList<ModuleService> services = new ArrayList<ModuleService>();
                int i = 0;
                while (i < entryPoints.size()) {
                    entryPoint = (EntryPoint)entryPoints.get(i);
                    moduleService = SCAFactory.eINSTANCE.createModuleService();
                    moduleService.setEntryPoint(entryPoint);
                    services.add(moduleService);
                    ++i;
                }
                theCurrentValues.addAll(services);
                break;
            }
            case 1: {
                List externalServices = module.getExternalServices();
                ModuleReference moduleReference = null;
                ExternalService externalService = null;
                ArrayList<ModuleReference> references = new ArrayList<ModuleReference>();
                int i = 0;
                while (i < externalServices.size()) {
                    externalService = (ExternalService)externalServices.get(i);
                    if (!externalService.isSetOverridable() || externalService.getOverridable().getValue() != 0) {
                        moduleReference = SCAFactory.eINSTANCE.createModuleReference();
                        moduleReference.setExternalService(externalService);
                        references.add(moduleReference);
                    }
                    ++i;
                }
                theCurrentValues.addAll(references);
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus hasValidComponentType() {
        if (this.getModule() != null) {
            return Status.OK_STATUS;
        }
        return STPCorePlugin.createErrorStatus(0, "Valid component type not available because the 'Module' implementation is not available.", null);
    }

    public IStatus onModelChange(int theFieldType, int theChangeType, Object theChangedObject) {
        if (this.disposed) {
            return STPCorePlugin.createErrorStatus(0, "ModuleComponentTypeIntrospector is already disposed in onModelChange()!", null);
        }
        EObject eObj = (EObject)theChangedObject;
        switch (theFieldType) {
            case 0: {
                switch (theChangeType) {
                    case 3: {
                        if (eObj instanceof ModuleService) {
                            ModuleService mService = (ModuleService)eObj;
                            Module module = this.getModule();
                            if (module == null) {
                                return this.hasValidComponentType();
                            }
                            if (mService.getEntryPoint() != null) {
                                EntryPoint epoint = mService.getEntryPoint();
                                if (!module.getEntryPoints().contains(epoint)) {
                                    module.getEntryPoints().add(epoint);
                                    break;
                                }
                                return Status.OK_STATUS;
                            }
                            EntryPoint epoint = SCAFactory.eINSTANCE.createEntryPoint();
                            epoint.setInterface(mService.getInterface());
                            epoint.setName(mService.getName());
                            mService.setEntryPoint(epoint);
                            module.getEntryPoints().add(epoint);
                            break;
                        }
                        if (!(eObj instanceof Service)) break;
                        Service service = (Service)eObj;
                        EntryPoint epoint = SCAFactory.eINSTANCE.createEntryPoint();
                        epoint.setInterface(service.getInterface());
                        epoint.setName(service.getName());
                        this.module.getEntryPoints().add(epoint);
                        break;
                    }
                    case 4: {
                        Service service;
                        EntryPoint epoint;
                        if (eObj instanceof ModuleService) {
                            ModuleService mService = (ModuleService)eObj;
                            Module module = this.getModule();
                            if (module == null) {
                                return this.hasValidComponentType();
                            }
                            if (mService.getEntryPoint() != null) {
                                EntryPoint epoint2 = mService.getEntryPoint();
                                if (module.getEntryPoints().contains(epoint2)) {
                                    module.getEntryPoints().remove(epoint2);
                                    break;
                                }
                                return Status.OK_STATUS;
                            }
                            EntryPoint epoint3 = module.getEntryPoint(mService.getName());
                            if (epoint3 == null) break;
                            module.getEntryPoints().remove(epoint3);
                            break;
                        }
                        if (!(eObj instanceof Service) || (epoint = this.module.getEntryPoint((service = (Service)eObj).getName())) == null) break;
                        this.module.getEntryPoints().remove(epoint);
                    }
                }
                break;
            }
            case 1: {
                switch (theChangeType) {
                    case 3: {
                        if (eObj instanceof ModuleReference) {
                            ModuleReference mReference = (ModuleReference)eObj;
                            Module module = this.getModule();
                            if (mReference.getExternalService() != null) {
                                ExternalService eservice = mReference.getExternalService();
                                if (!module.getExternalServices().contains(eservice)) {
                                    module.getExternalServices().add(eservice);
                                    break;
                                }
                                return Status.OK_STATUS;
                            }
                            ExternalService eservice = SCAFactory.eINSTANCE.createExternalService();
                            eservice.setInterface(mReference.getInterface());
                            eservice.setName(mReference.getName());
                            mReference.setExternalService(eservice);
                            module.getExternalServices().add(eservice);
                            break;
                        }
                        if (!(eObj instanceof Reference)) break;
                        Reference service = (Reference)eObj;
                        ExternalService eservice = SCAFactory.eINSTANCE.createExternalService();
                        eservice.setInterface(service.getInterface());
                        eservice.setName(service.getName());
                        this.module.getExternalServices().add(eservice);
                        break;
                    }
                    case 4: {
                        Reference service;
                        ExternalService eservice;
                        if (eObj instanceof ModuleReference) {
                            ModuleReference mReference = (ModuleReference)eObj;
                            Module module = this.getModule();
                            if (mReference.getExternalService() != null) {
                                ExternalService eservice2 = mReference.getExternalService();
                                if (module.getExternalServices().contains(eservice2)) {
                                    module.getExternalServices().remove(eservice2);
                                    break;
                                }
                                return Status.OK_STATUS;
                            }
                            ExternalService eservice3 = module.getExternalService(mReference.getName());
                            if (eservice3 == null) break;
                            module.getExternalServices().remove(eservice3);
                            break;
                        }
                        if (!(eObj instanceof Reference) || (eservice = this.module.getExternalService((service = (Reference)eObj).getName())) == null) break;
                        this.module.getExternalServices().remove(eservice);
                    }
                }
                break;
            }
            case 2: {
                switch (theChangeType) {
                    default: 
                }
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus save() {
        if (this.disposed) {
            return STPCorePlugin.createErrorStatus(0, "ModuleComponentTypeIntrospector is already disposed in save()!", null);
        }
        if (this.scribbler != null) {
            try {
                this.scribbler.save(false, null);
            }
            catch (EditModelException e) {
                STPCorePlugin.logError(0, e.getMessage(), e);
                return STPCorePlugin.createErrorStatus(0, e.getMessage(), e);
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus dispose() {
        if (this.scribbler != null) {
            try {
                this.scribbler.close(null);
                this.scribbler = null;
                this.module = null;
                this.disposed = true;
            }
            catch (EditModelException e) {
                STPCorePlugin.logError(0, e.getMessage(), e);
                return STPCorePlugin.createErrorStatus(0, e.getMessage(), e);
            }
        }
        return Status.OK_STATUS;
    }

    public Object resolveImplementation() {
        if (this.disposed) {
            STPCorePlugin.logError(0, "ModuleComponentTypeIntrospector is already disposed in save()!", null);
            return null;
        }
        return this.getModule();
    }

    private Module getModule() {
        if (this.module == null || this.module.getEObject().eIsProxy()) {
            try {
                Resource resource = this.getScribbler().getResource(this.domain.getCompositeDescriptor());
                if (resource.getContents().size() == 1) {
                    SCACoreRoot root = (SCACoreRoot)resource.getContents().get(0);
                    this.module = root.getModule();
                }
            }
            catch (EditModelException e) {
                STPCorePlugin.logError(0, e.getMessage(), e);
            }
        }
        return this.module;
    }

    private IEditModelScribbler getScribbler() throws EditModelException {
        if (this.scribbler == null) {
            this.scribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(this.domain.getProject(), (IScribblerDomain)this.domain);
        }
        return this.scribbler;
    }
}

