package org.eclipse.stp.core.infrastructure.operations;

import org.eclipse.wst.common.frameworks.datamodel.IDataModelProperties;

public interface IAbstractScribblerDataModelProperties extends
      IDataModelProperties {
   /**
    * [REQUIRED] Property for project name.
    * 
    * Type = {@link String}
    */
   public static final String PROJECT_NAME      = "IAbstractScribblerDataModelProperties.PROJECT_NAME";     //$NON-NLS-1$

   /**
    * [REQUIRED] Array of EditModel Scribbler domains. A new Scribbler for write
    * will be created within the operation, saved and finally closed.
    * 
    * Type = {@link org.eclipse.stp.core.infrastructure.emf.IScribblerDomain []}
    */
   public static final String SCRIBBLER_DOMAINS = "IAbstractScribblerDataModelProperties.SCRIBBLER_DOMAINS"; //$NON-NLS-1$

   /**
    * [REQUIRED] Edit Model label. A new Scribbler for write will be created
    * within the operation, saved and finally closed.
    * 
    * Type = {@link String}
    */
   public static final String EDIT_MODEL_LABEL  = "IAbstractScribblerDataModelProperties.EDIT_MODEL_LABEL"; //$NON-NLS-1$

   /**
    * [READ-ONLY] Object that was created as a result of this operation.
    * 
    * Type = {@link Object}
    */
   public static final String RESULT            = "IAbstractScribblerDataModelProperties.RESULT";           //$NON-NLS-1$
}
