/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
/*
 * Created on Mar 3, 2004
 * 
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.stp.core.internal.infrastructure.emfworkbench;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.util.emf.workbench.EMFWorkbenchContextFactory;
import org.eclipse.jem.util.emf.workbench.EMFWorkbenchContextBase;
import org.eclipse.jem.util.emf.workbench.ResourceSetWorkbenchSynchronizer;
import org.eclipse.stp.core.infrastructure.emf.IEMFWorkbenchContext;
import org.eclipse.stp.core.infrastructure.emf.IEMFWorkbenchContextFactory;
import org.eclipse.stp.core.infrastructure.emf.IResourceAssistant;
import org.eclipse.stp.core.infrastructure.emf.IResourceAssistantFactory;

public class EMFWorkbenchEditContextFactory extends EMFWorkbenchContextFactory
      implements IEMFWorkbenchContextFactory {

   public static final EMFWorkbenchEditContextFactory sINSTANCE          = new EMFWorkbenchEditContextFactory();

   private final Set                                  resourceAssistants = new HashSet();

   /**
    * @see IEMFWorkbenchContextFactory#getContext(IProject)
    */
   public IEMFWorkbenchContext getContext(IProject aProject) {

      return (IEMFWorkbenchContext) sINSTANCE.createEMFContext(aProject, null);
   }

   public ResourceSetWorkbenchSynchronizer createSynchronizer(
         ResourceSet aResourceSet, IProject aProject) {
      return new ResourceSetWorkbenchEditSynchronizer(aResourceSet, aProject);
   }

   protected EMFWorkbenchContextBase primCreateEMFContext(IProject aProject) {
      EMFWorkbenchContext context = new EMFWorkbenchContext(aProject);
      createResourceAssistants(aProject, context);
      return context;
   }

   private void createResourceAssistants(IProject aProject,
         EMFWorkbenchContext context) {
      if (resourceAssistants.size() > 0) {
         for (Iterator assistantItr = resourceAssistants.iterator(); assistantItr
               .hasNext();) {
            IResourceAssistantFactory factory = (IResourceAssistantFactory) assistantItr
                  .next();
            IResourceAssistant assistant = factory
                  .createResourceAssistant(aProject);
            if (assistant != null)
               context.installResourceAssistant(assistant);
         }
      }
   }

   public void installResourceAssistantFactory(
         IResourceAssistantFactory aResourceAssistantFactory) {
      resourceAssistants.add(aResourceAssistantFactory);

   }

   public void uninstallResourceAssistantFactory(
         IResourceAssistantFactory aResourceAssistantFactory) {
      resourceAssistants.remove(aResourceAssistantFactory);

   }
}
